Com.Frog.Utils.require(
    '//package/widgets/CFF94E182001B66D20BC4F7066860807423B6F5CEDC19E01/assets/styles/main.css',
    '//package/widgets/CFF94E182001B66D20BC4F7066860807423B6F5CEDC19E01/assets/views/main.ejs',
    '//package/widgets/CFF94E182001B66D20BC4F7066860807423B6F5CEDC19E01/widget.ejs'
).then(function() {
    Com.Frog.Controllers.Widget.extend('Widget.ImageButton', {
    }, {
        prefs: {
            link_title: {
                type: 'text',
                label: 'Link title',
                defaultValue: ''
            },
            link_type: {
                type: 'radio',
                label: 'Link type',
                options: {
                    'Page on this site':'page',
                    'Frog Site': 'site',
                    'Frog App': 'app',
                    'File': 'file',
                    'Web address': 'url'
                },
                vertical: true,
                defaultValue: 'page',
                publish: []
            },
            page: {
                type: 'pagepicker',
                label: 'Use the Site select to find this site, then select a page',
                defaultValue: JSON.stringify({
                    page_uuid:'',
                    site_uuid:''
                }),
                accordion: 'Page selection'
            },
            site: {
                type: 'site',
                label: 'Select a Frog Site',
                defaultValue:  '',
                accordion: 'Frog Site selection'
            },
            app: {
                type: 'app',
                label: 'Select a Frog Application',
                defaultValue: '',
                accordion: 'Frog App selection'
            },
            file: {
                type: 'upload',
                label: 'Upload a file or choose from Site Assets',
                showDiscover: false,
                showClipboard: false,
                view: 'mini',
                sources: ['native'],
                accordion: 'File settings'
            },
            url: {
                type: 'url',
                editable: true,
                label: 'Web address',
                placeholder: '',
                defaultValue: '',
                accordion: 'Internet link settings'
            },
            icon: {
                type: 'list',
                label: 'Choose an icon',
                options: {
                    'Academic Monitoring':'Academic-Monitoring',
                    'Achievements':'achievements',
                    'Agreements':'Agreements',
                    'Analytics':'analytics',
                    'Assignment Manager':'markbook-manager',
                    'Assgnment monitor':'assgnment-monitor',
                    'Assignment':'assignment',
                    'Avatar builder':'avatar-builder',
                    'Booking calendar':'booking-calendar',
                    'Buddies':'buddies',
                    'Calendar':'calendar',
                    'Code editor':'code-editor',
                    'Curriculum designer':'curriculum-designer',
                    'Data viewer':'data-viewer',
                    'Developer management':'developer-managment',
                    'Discover':'discover',
                    'Document':'document',
                    'ePortfolio':'ePortfolio',
                    'Equip Booking':'Equip_Booking',
                    'Feedback':'feedback',
                    'Forms':'forms',
                    'Frog Community':'frogcommunity',
                    'Frogconnect':'frogconnect',
                    'Frogdrive':'frogdrive',
                    'FrogPlay videos':'frogplay-videos_1',
                    'FrogPlay':'frogplay',
                    'FrogStore Original':'FrogStore_Original',
                    'FrogStore':'frogstore',
                    'Gallery':'Gallery',
                    'Groups':'groups-and-policies',
                    'Homework':'Homework',
                    'Information':'information',
                    'IT Management':'IT_Management',
                    'IT Support':'IT_Support',
                    'Leaderboard':'leaderboard',
                    'Learn':'Learn',
                    'Markscheme manager':'markscheme-manager',
                    'Messaging':'messaging',
                    'My child':'my-child',
                    'My childs progress':'my-childs-progress',
                    'My childs work':'my-childs-work',
                    'My class':'my-class',
                    'My documents':'my-documents',
                    'My Frog':'my-frog',
                    'Notes':'Notes',
                    'Notices':'Notices',
                    'Notifications':'notifications',
                    'Outlook':'outlook_1',
                    'Package manager':'package-manager',
                    'Parent manager':'parent-manager',
                    'Password':'password-reset',
                    'Personal dashboard':'personal-dashboard',
                    'Planner':'Planner',
                    'Play':'Play',
                    'Polls':'polls',
                    'Printers':'Printers',
                    'Progress':'Progress',
                    'Quick Launch':'quicklaunch',
                    'Quizzes':'quizzes',
                    'Quiz reports':'quiz_report',
                    'Recipes':'Recipes',
                    'Reporting':'reporting',
                    'Revision':'revision',
                    'Ribbets':'ribbets',
                    'School Info':'School_Info',
                    'School dashboard':'school-dashboard',
                    'Settings':'settings',
                    'Sites Copy':'sites-exporter',
                    'Sites':'sites',
                    'Student tracker':'student-tracker',
                    'Support':'support',
                    'Switch dashboard':'switch-dashboard',
                    'System Preferences':'system-preferences',
                    'Timelines':'timelines',
                    'Timetable':'timetable',
                    'Uploader':'uploader',
                    'User Info':'User_Info',
                    'User Management':'User_Management',
                    'users':'users',
                    'Custom (use the File settings to add image)': 'custom'
                },
                defaultValue: 'frogcommunity'
            },
            height: {
                type: 'number',
                label: 'Image size',
                defaultValue: 162,
                showUnits: 'px',
                accordion: 'Design settings'
            },
            textheight: {
                type: 'number',
                label: 'Text size',
                defaultValue: 20,
                showUnits: 'px',
                accordion: 'Design settings'
            },
            textcolour: {
                type: 'colourpicker',
                label: 'Text colour',
                defaultValue: '#0071b9',
                accordion: 'Design settings'
            },
            border: {
                type: 'radio',
                label: 'Border',
                vertical: true,
                options: {
                    'No border': 'none',
                    'Square border': 'square',
                    'Rounded corners': 'rounded'
                },
                defaultValue: 'none',
                publish: [],
                accordion: 'Design settings'
            },
            borderSize: {
                type: 'number',
                label: 'Border size',
                defaultValue: 1,
                showUnits: 'px',
                accordion: 'Design settings'
            },
            bgcolour: {
                type: 'colourpicker',
                label: 'Background colour',
                defaultValue: '#ffffff',
                accordion: 'Design settings'
            }
        },
        view_mode: 'live',
        app_name: '',
        packageID: 'CFF94E182001B66D20BC4F7066860807423B6F5CEDC19E01',

        init: function() {},

        'widget.live': function(el, ev, data) {
            this.view_mode = 'live';
            this.renderInEdit(); },

        'widget.edit': function(el, ev, data) {
            this.view_mode = 'edit';
            this.renderInEdit();
        },

        'widget.save': function(el, ev, data) {
            this.view_mode = 'edit';
            this.renderInEdit();
        },
        
        renderInEdit : function() {
            var self = this;
            self.element.html(
                self.view('main.ejs')
            );
            self.element.find('.image_button').css('height', self.prefs.height.value+'px');
            self.element.find('.image_title').css('font-size', self.prefs.textheight.value+'px');
            self.element.find('.image_title').css('color', self.prefs.textcolour.value);
            self.element.find('.image_link').css('background', self.prefs.bgcolour.value);
            if (self.prefs.border.value !== 'none') {
                self.element.find('.image_link').css('border', self.prefs.borderSize.value+'px solid '+self.prefs.textcolour.value);
                if (self.prefs.border.value == 'rounded') {
                    self.element.find('.image_link').css('border-radius', '6px');
                }
            }
            if (self.prefs.icon.value == 'custom' && self.prefs.file.value !== '') {
                var baseURL = Frog.Utilities.getBaseUrl()+'/app/';
                self.element.find('.image_button').attr('src',baseURL+self.prefs.file.value);
            }
            
            if (self.prefs.link_type.value == 'app' && self.prefs.app.value !== '') {
                Lib.Models.Applications.findOne(self.prefs.app.value).done(function(app) {
                    self.app_name = app.app_name;

                    if (self.prefs.link_title.value == '') {
                        self.element.find('.image_title').html(app.name);
                    }
                });
            }

            if (self.view_mode == 'live') {
                
                
                if(self.prefs.link_type.value == 'page')  {
                    var page_opts = JSON.parse(self.prefs.page.value);
                    Frog.Model.api('pages.getNavigation', {
                        site: page_opts.site_uuid
                    }).done(function(res) {
                        
                        var page_opts = JSON.parse(self.prefs.page.value),
                            pages = res.data.children,
                            find = function(pages, page_uuid){ // 3 tier of navigation to wade through to return correct page data, based on page uuid
                                var pageData = [],
                                    link = '',
                                    pageName = '';
                                $.each(pages, function(k1, d1) {
                                    if (link === '' && d1.node.uuid === page_uuid) {
                                        link = d1.node.link;
                                    }
                                    if (d1.hasOwnProperty("children")) {
                                        $.each(d1.children, function(k2, d2) {
                                            if (link === '' && d2.node.uuid === page_uuid) {
                                                link = d2.node.link;
                                        }
                                        if (d2.hasOwnProperty("children")) {
                                            $.each(d2.children, function(k3, d3) {
                                                if (link === '' && d3.node.uuid === page_uuid) {
                                                    link = d3.node.link;
                                                }
                                            });
                                        }
                                    });
                                }
                            });
                            pageData[0] = link;
                            return pageData;
                        };
                        var pageData = find(res.data.children, page_opts.page_uuid);
                        self.element.find('.image_link').attr('data-page-link-cke', pageData[0]);
                        self.element.find('.image_link').attr('alt', pageData[0]);
                    });
                }
            }
        },
        
        '.image_link click': function(ev) {
            if (this.view_mode == 'live') {
                switch(this.prefs.link_type.value) {
                    case 'file':
                        Frog.Utilities.download(this.prefs.file.value,true);
                        break;
                    case 'app':
                        this.element.trigger(FrogOS.openApp(this.app_name));
                        break;
                    case 'site':
                        this.element.trigger('os.app.siteviewer', { data: { site: this.prefs.site.value  }});
                        break;
                    case 'url':
                        window.open(this.prefs.url.value, '_blank');
                        break;
                    default:
                        break;   
                }
            }
        },

        'widget.updated': function(el, ev, data) {}
    });
});
