Com.Frog.Utils.require(
    '//package/widgets/673D14512001B5F7EB31BF83ADB9940B5162E7FCB5F2FBC3/assets/styles/main.css',
    '//package/widgets/673D14512001B5F7EB31BF83ADB9940B5162E7FCB5F2FBC3/assets/views/main.ejs',
    '//package/widgets/673D14512001B5F7EB31BF83ADB9940B5162E7FCB5F2FBC3/assets/views/doc_iframe.ejs',
    '//package/widgets/673D14512001B5F7EB31BF83ADB9940B5162E7FCB5F2FBC3/widget.ejs'
).then(function() {
    Com.Frog.Controllers.Widget.extend('Widget.GoogleEmbed', {
    }, {
        prefs: {
            shareLink: {
                type: 'text',
                label: 'In your Google Doc: click Share, then Copy Link. Paste copied link here:',
                defaultValue: ''
            },
            height: {
                type: 'number',
                label: 'Height',
                showUnits: 'px',
                defaultValue: 600
            },
            editLink: {
                type: 'radio',
                label: 'Edit Link',
                options: {
                    'Show Edit option': 'edit',
                    'Preview only': 'preview'
                },
                defaultValue: 'edit'
            }
        },

        packageID: '673D14512001B5F7EB31BF83ADB9940B5162E7FCB5F2FBC3',

        init: function() {},

        'widget.live': function(el, ev, data) {
            var shareURL = '';
            this.element.html(
                this.view('main.ejs')
            );

            var shareLink = this.prefs.shareLink.value;
            
            if (shareLink !== '') {
                this.element.find('.warn').hide();
                this.element.find('.embed_here').html(
                    this.view('doc_iframe.ejs', {
                        shareURL: this.prefs.shareLink.value.replace('edit','preview'),
                        editLink: this.prefs.shareLink.value
                    })
                );
            }
        },

        'widget.edit': function(el, ev, data) {
            this.renderInEdit();
        },
        'widget.save': function(el, ev, data) {
            this.renderInEdit();
        },
        renderInEdit : function() {
            this.element.html(
                this.view('./widget.ejs')
            );
            this.element.find('.place_holder').css('height',this.prefs.height.value+'px');
        },

        'widget.updated': function(el, ev, data) {}
    });
});
