Com.Frog.Utils.require(
    '//package/widgets/3F7E460C2001B723BACECFB32D1BE70A2F0CC52C80AE5CA2/assets/styles/main.css',
    '//package/widgets/3F7E460C2001B723BACECFB32D1BE70A2F0CC52C80AE5CA2/assets/views/main.ejs',
    '//package/widgets/3F7E460C2001B723BACECFB32D1BE70A2F0CC52C80AE5CA2/widget.ejs'
).then(function() {
    Com.Frog.Controllers.Widget.extend('Widget.MultifileUpload', {
    }, {
        prefs: {
            widget_title: {
                type: "text",
                label: "Widget title",
                defaultValue: "Files"
            },
             hide_title: {
                type: 'radio',
                label: "Hide title?",
                vertical: false,
                options: {
                    'Yes': 'yes',
                    'No': 'no'
                },
                defaultValue: "no",
                publish: []
            },
            default_view : {
                type: "list",
                label: "Select a default view",
                defaultValue: "icons",
                options : {
                    "Icons" : "icons",
                    "List" : "list"
                }
            },
             hide_menu: {
                type: 'radio',
                label: "Hide action menu to somebody with only 'view' permissions? (Regardless they will not be able to add or delete files)",
                vertical: false,
                accordion: 'settings.advanced',
                options: {
                    'Yes': 'yes',
                    'No': 'no'
                },
                defaultValue: "no",
                publish: []
            },
            widget_height : {
                type: "list",
                label: "Select a height for the widget",
                defaultValue: "265px",
                accordion: 'settings.advanced',
                options : {
                    "Auto height (fit contents)" : "auto",
                    "Fixed height (regular)" : "265px",
                    "Fixed height (large)" : "365px"
                }
            }
        },

        packageID: '3F7E460C2001B723BACECFB32D1BE70A2F0CC52C80AE5CA2',
        /**
         * Constructor. Runs when the widget is first loaded.
         *
         * @method init
         */
        init: function() {},

        /**
         * Event fired by the Site Controller.
         *
         * @event 'widget.live'
         */
        'widget.live': function(el, ev, data) {
            this.element.html(
                this.view('main.ejs')
            );

            var widget = this;
            widget.element.find('div.addfile').hide();
            var currentuser = FrogOS.getUser();
            var perms = this.options.sitePermission;    //admin, view, contribute
            var baseURL = Frog.Utilities.getBaseUrl();
            var site_uuid = this.options.site_uuid;
            var widget_instance_uuid = widget.options.content_uuid
            var display_mode = this.prefs.default_view.value;
            var sort_mode = "name";
            var data_store = [];
            var myuuid = '';
            
            
            
           
            var DisplayFiles = function() {
                if (sort_mode == "name") {
                    SortByName();
                } else if (sort_mode == "type") {
                    SortByType();
                } else {
                    SortByDate();
                }
                widget.element.find('div.resources-container').empty();
                
                if (display_mode == 'icons') {
                    widget.element.find('div.resources-container').append("<div class=\"list-wrapper os-rec-inner-cont frog-touch-scroll frogui_components_infinitescroller\"><ul class=\"resource-list\"></ul></div>");
                    $.each(data_store, function(key, file) {
                        var n = file.url.split("/app/");
                        var url = "https://" + window.location.hostname + "/app/" + n[1];
                        widget.element.find('ul.resource-list').append("<li data-url=\""+$.EJS.clean(url)+"\" data-uuid=\""+$.EJS.clean(file.uuid)+"\" class=\"editable resource-files template-icon rv-resource draggable ui-draggable resource\" draggable=\"false\"><div class=\"icon resources-resource-icon os-icon-ext os-icon-ext-"+$.EJS.clean(file.ext)+"\"><span class=\"os-ellipsis file-name\">"+$.EJS.clean(file.ext)+"</span></div><div class=\"editable name row-fluid\"><a class=\"span12\" href=\"#\" title=\""+$.EJS.clean(file.name)+"\" draggable=\"false\">"+$.EJS.clean(file.name)+"</a><input class=\"span12 hide\" type=\"text\" name=\"resourceName\" placeholder=\""+$.EJS.clean(file.name)+"\" value=\""+$.EJS.clean(file.name)+"\"></div></li>");
                    });
                } else {
                    var layout = "<div class=\"list-wrapper inner-content frog-touch-scroll frogui_components_infinitescroller\"><table class=\"table table-striped\"><thead><tr><th class=\"icon\"></th><th class=\"title\">Title</th><th class=\"date\">Date Created</th></tr></thead><tbody class=\"resource-list\">";
                    $.each(data_store, function(key, file) {
                        var n = file.url.split("/app/");
                        var url = "https://" + window.location.hostname + "/app/" + n[1];
                        layout = layout + "<tr data-url=\""+url+"\" data-uuid=\""+$.EJS.clean(file.uuid)+"\" class=\"resource-files template-list rv-resource draggable ui-draggable resource\"><td class=\"icon\"><span class=\"resources-resource-icon os-icon-ext os-icon-ext-"+$.EJS.clean(file.ext)+" small\"></span></td><td data-sort-value=\""+$.EJS.clean(file.name)+"\"><div class=\"os-ellipsis\">"+$.EJS.clean(file.name)+"</div></td><td data-sort-value=\""+$.EJS.clean(file.dadded)+"\"><div class=\"os-ellipsis\">"+$.EJS.clean(moment.unix(file.dadded).format("DD/MM/YYYY"))+"</div></td></tr>";
                    });  
                    layout = layout + "</tbody></table></div>"
                    widget.element.find('div.resources-container').append(layout);
                }               
                CheckBoxSize();
            };
            
            
            //////////////////// save and load functions for google ////////////////////////////////////////////
            function SaveData() {
                var array = JSON.stringify(data_store);
                var qs = "&uuid="+widget_instance_uuid+"&sheet=Sheet1&action=newupdate";
                var save_request = $.ajax({
                    url: "https://script.google.com/macros/s/AKfycbwtSx1Nwe4DewsCGX1NgeC4lZjeJmNkjTfPYFEFmWfcfhDRc0WV/exec?docid=1ZZvK55PZKNG8NR7JYjfn65HCKjqRv8FrYqUaL6suVSc"+qs,
                    dataType: "json",
                    data: { data: array }
                });
                
                save_request.fail(function (jqXHR, textStatus, errorThrown){
                    widget.element.find('div.resources-container').html("There was an error.");
                });
                
                save_request.always(function () {
                    
                });
            }
            
            function clearFromGoogle() {
                var clear = "[]";
                var qs = "&uuid="+widget_instance_uuid+"&sheet=Sheet1&action=newupdate";
                var save_request = $.ajax({
                    url: "https://script.google.com/macros/s/AKfycbwtSx1Nwe4DewsCGX1NgeC4lZjeJmNkjTfPYFEFmWfcfhDRc0WV/exec?docid=1ZZvK55PZKNG8NR7JYjfn65HCKjqRv8FrYqUaL6suVSc"+qs,
                    dataType: "json",
                    data: { data: clear }
                });
            }

            function SaveDataFrog() {
                var params = {
                    target_uuid: widget_instance_uuid,
                    alias: widget_instance_uuid,
                    user_uuid: FrogOS.getUser().uuid,
                    data: JSON.stringify(data_store)
                }
                var method = 'datastore/create';
                if (myuuid != '') {
                    method = 'datastore/update';
                    params.uuid = myuuid;
                }

                FrogOS.fdp({
                    url: method,
                    path: '/api/fdp/2/',
                    type: 'POST',
                    data: params
                }).done(function(response) {
                    myuuid = response.response.uuid;
                    clearFromGoogle();
                }.bind(this)).fail(function(e) {
                    // Report Error
                    widget.element.find('div.resources-container').html("There was an error.");
                });
            }

            
            function LoadData() {
                var loadsaved_data = $.ajax({
                    url: "https://script.google.com/macros/s/AKfycbwtSx1Nwe4DewsCGX1NgeC4lZjeJmNkjTfPYFEFmWfcfhDRc0WV/exec?docid=1ZZvK55PZKNG8NR7JYjfn65HCKjqRv8FrYqUaL6suVSc&sheet=Sheet1&action=loaddata&uuid="+widget_instance_uuid,
                    dataType: "json"
                });

                loadsaved_data.done(function (response, textStatus, jqXHR){
                    if (response.values.length) {
                        data_store = JSON.parse(response.values[0].data);
                        if (perms !== 'view') {
                            SaveDataFrog();
                        }
                    }
                });

                loadsaved_data.fail(function (jqXHR, textStatus, errorThrown){
                    widget.element.find('div.resources-container').html("There was an error.");
                });

                loadsaved_data.always(function () {
                    DisplayFiles();
                });
            }
            
            
            function LoadDataFrog() {
                var params = {
                    target_uuid: widget_instance_uuid,
                    alias: widget_instance_uuid
                }
                FrogOS.fdp({
                    url: 'datastore/get',
                    path: '/api/fdp/2/',
                    type: 'GET',
                    data: params
                }).done(function(response) {
                    if (response.response.length) {
                        data_store = JSON.parse(response.response[0].data);
                        myuuid = response.response[0].uuid
                        DisplayFiles();
                    } else {
                        LoadData();
                    }
                }.bind(this)).fail(function(e) {
                    // Report Error
                    LoadData();
                });  
            }

            ///////////////////////////////////////////////////////////////////////////////////////

            
            /////////// btnUploader_click() /////////////////////////////////////////////////
            widget.element.find('li.upload-file').on('click', function(ev) {
                $('.os_core:first').trigger('os.app.upload', {
                    "data": {
                        "upload_type": "asset",
                        "site_uuid": site_uuid,
                        "focusApp": widget.element.closest('div.app_dialog'),
                        "callback": function(result) {
                            if (result.files && result.files.length) {
                                $.each(result.files, function(i, file) {
                                    data_store.push({uuid: file.uuid, name: file.attachment.name, ext: file.attachment.file.mime.ext, url:file.external_url, dadded:file.attachment.updated});
                                });
                                //SaveData();
                                SaveDataFrog();
                                DisplayFiles(); 
                            }
                        }
                    }
                });
            });
            //////////////////////////////////////////////////////////////////////////////////////////////
                  
            
             /////////// Sorting_clicks() ////////////////////////////////////////////////////////////////
            widget.element.find('li.actionmenu-item-toggle').on('click', function(ev) {
                if ( $(this).hasClass("resources-filter-file-date-added") ) {
                    sort_mode = "date";
                } else if ( $(this).hasClass("resources-filter-file-type") ) {
                    sort_mode = "type";
                } else {
                    sort_mode = "name"; 
                }
                DisplayFiles();
            }); 
            /////////////////////////////////////////////////////////////////////////////////////////////// 

            
             /////////// btnDelete_click() ///////////////////////////////////
            widget.element.find('li.resources-file-delete').on('click', function(ev) {
                if (perms !== 'view') {
                    var uuid = widget.element.find(".selected.active-lozenge").data("uuid");
                    data_store = data_store.filter(function (el) {
                        return el.uuid !== uuid;
                    });
                    widget.element.find(".selected.active-lozenge").remove();
                    ActionMenu("disable");
                    //SaveData();
                    SaveDataFrog();
                }
            });
            //////////////////////////////////////////////////////////////////////
            
            
            /////////// btnRefresh_click() ///////////////////////////////////
            widget.element.find('li.resources-refresh').on('click', function(ev) {
                ActionMenu("disable");
                DisplayFiles(); 
            });
            //////////////////////////////////////////////////////////////////////
            
            
            /////////// File_click() /////////////////////////////////// 
            widget.element.find('div.mywrapper').on('click', ".resource-files", function(ev) { 
                widget.element.find('.resource-files').removeClass("selected active-lozenge");
                $(ev.currentTarget).addClass("selected active-lozenge");
                ActionMenu("enable");
            });
            //////////////////////////////////////////////////////////////////////
            
            
             /////////// File_doubleClick() /////////////////////////////////// 
            this.element.find('div.mywrapper').on('dblclick tap', ".resource-files", function(ev) {
                window.open($(ev.currentTarget).data("url"));
                //console.log($(ev.currentTarget).data("url"));
            }.bind(this));
            //////////////////////////////////////////////////////////////////////
            
            
            /////////// icoView_toggle() /////////////////////////////////////////////
            widget.element.find('button.resources-view').on('click', function(ev) {    
                widget.element.find('button.resources-view').removeClass("selected");
                $(this).addClass("selected");
                if ( $(this).hasClass("resources-view-list") ) {
                    display_mode = "list";
                } else {
                    display_mode = "icons";
                }
                DisplayFiles();
            });
            //////////////////////////////////////////////////////////////////////

            
           //////////////utility functions ///////////////////////
            function SortByName() {
                widget.element.find(".actionmenu-item-toggle").removeClass("actionmenu-item-toggled");
                widget.element.find("li.resources-filter-file-name").addClass("actionmenu-item-toggled")
                data_store.sort(function(a, b){
                    var x = a.name.toLowerCase();
                    var y = b.name.toLowerCase();
                    if (x < y) {return -1;}
                    if (x > y) {return 1;}
                    return 0;
                });
            }
            
            function SortByType() {
                widget.element.find(".actionmenu-item-toggle").removeClass("actionmenu-item-toggled");
                widget.element.find("li.resources-filter-file-type").addClass("actionmenu-item-toggled")
                data_store.sort(function(a, b){
                    var x = a.ext.toLowerCase();
                    var y = b.ext.toLowerCase();
                    if (x < y) {return -1;}
                    if (x > y) {return 1;}
                    return 0;
                });
            }
            
            function SortByDate() {
                widget.element.find(".actionmenu-item-toggle").removeClass("actionmenu-item-toggled");
                widget.element.find("li.resources-filter-file-date-added").addClass("actionmenu-item-toggled")
                data_store.sort(function(a, b){return a.dadded - b.dadded});
            }
            
            function ActionMenu(status) {
                if (perms !== 'view') {
                    if (status == "enable") {
                        widget.element.find('li.resources-file-copy').removeClass("actionmenu-item-disabled");
                        widget.element.find('li.resources-file-delete').removeClass("actionmenu-item-disabled");
                        widget.element.find('li.resources-file-replace').removeClass("actionmenu-item-disabled");
                    } else {
                        widget.element.find('li.resources-file-copy').addClass("actionmenu-item-disabled");
                        widget.element.find('li.resources-file-delete').addClass("actionmenu-item-disabled");
                        widget.element.find('li.resources-file-replace').addClass("actionmenu-item-disabled");
                    }
                }
            }
            
            function CheckBoxSize() {
                if (widget.prefs.widget_height.value == '265px') {
                    widget.element.find('div.resources-container').height('265px');
                    widget.element.find('div.list-wrapper').height('265px');
                } else if (widget.prefs.widget_height.value == '365px') {
                    widget.element.find('div.resources-container').height('365px');
                    widget.element.find('div.list-wrapper').height('365px');
                } else {
                    //auto - set a min height to fit dropdown or a single file if no dropdown available
                    if (widget.element.find('div.actions-wrapper').is(':visible')) {
                        widget.element.find('div.resources-container').css('min-height', '150px');
                        widget.element.find('div.list-wrapper').css('min-height', '150px');
                    } else {
                        widget.element.find('div.resources-container').css('min-height', '100px');
                        widget.element.find('div.list-wrapper').css('min-height', '100px');
                    }
                }
            }
            
            ////////////////////////////////////////////////////
            widget.element.find('div.theme-headerbg').html("<h2> "+this.prefs.widget_title.value+"</h2>");
            if (this.prefs.hide_title.value == "yes") {
                widget.element.find('div.theme-headerbg').hide();
            } else {
                widget.element.find('div.theme-headerbg').show();
            }
            if (this.prefs.hide_menu.value == "yes") {
                if (perms == 'view') {
                    widget.element.find('div.actions-wrapper').hide();
                    CheckBoxSize();
                }
            } else {
                widget.element.find('div.actions-wrapper').show();
            }
            if (display_mode !== 'icons') {
                widget.element.find('button.resources-view').removeClass("selected");
                widget.element.find('button.resources-view-list').addClass("selected");
            }
            if (perms !== 'view') {
                widget.element.find('div.addfile').show();
            }
            
            
            LoadDataFrog();
            ////////////////////////////////////////////////////

        },

        /**
         * Event fired by the Site Controller. Tells the widget that the site is in Edit Mode.
         *
         * @event 'widget.edit'
         */
        'widget.edit': function(el, ev, data) {
            this.element.html(
                this.view('./widget.ejs')
            );
        },

        /**
         * Event fired by the Site Controller. Tells the widget that something has been changed during editing.
         *
         * @event 'widget.updated'
         */
        'widget.updated': function(el, ev, data) {}
    });
});
