Com.Frog.Utils.require(
    '//package/widgets/C136DBF42001BE49457A7FF5571790059D5779FC5184B4E1/assets/styles/main.css',
    '//package/widgets/C136DBF42001BE49457A7FF5571790059D5779FC5184B4E1/assets/views/main.ejs',
    '//package/widgets/C136DBF42001BE49457A7FF5571790059D5779FC5184B4E1/assets/views/row.ejs',
    '//package/widgets/C136DBF42001BE49457A7FF5571790059D5779FC5184B4E1/widget.ejs'
).then(function() {
    Com.Frog.Controllers.Widget.extend('Widget.AssignmentList', {
    }, {
        prefs: {
            dateFormat: {
                type: 'radio',
                defaultValue: 'DD/MM/YYYY',
                label: 'Display dates as:',
                vertical: true,
                options: {
                    '01/03/2023': 'DD/MM/YYYY',
                    '01-03-2023': 'DD-MM-YYYY',
                    '03-01-2023': 'MM-DD-YYYY',
                    '1st Mar 2023': 'Do MMM YYYY',
                    'Monday, 1st March 2023': 'dddd, Do MMMM YYYY',
                    'Mon, 1st Mar \'23': "ddd, Do MMM 'YY"
                },
                publish: []
            },
            associations: {
                'type': 'associations',
                'label': 'Widget Collections',
                'defaultValue': JSON.stringify({
                    'associations': [],
                    'publisher': false,
                    'subscriber': true
                })
            }
        },

        packageID: 'C136DBF42001BE49457A7FF5571790059D5779FC5184B4E1',
 
        init: function() {
            this.selected_subject = null;
        },


        'widget.live': function(el, ev, data) {
            this.render('live');
        },
        
        'broadcast.selectedUser': function(el, ev, options) {
            if (this.selected_student && this.selected_student.uuid === options.model.attr('uuid')) {
                return;
            }
            this.selected_student = options.model;
            this.render('brodacast');
        },
        
        render: function(view) {
            var self = this;
            var endOfToday = moment().utc().endOf('day').unix();
            var startOfToday = moment().utc().startOf('day').unix();
            var user = FrogOS ? FrogOS.getUser() : self.getUser();
          
            self.element.html(
                self.view('main.ejs')
            );
            var assList = self.element.find('.ass_list');
            
            if (self.selected_student !== undefined) {
                var data = {
                    assigned_user: self.selected_student.uuid,
                    status: 'open',
                    start_to: moment().unix(),
                    order: 'end'
                };            
                if (user.profile.name == 'Student') {
                    data = {
                        status: 'open',
                        start_to: moment().unix(),
                        order: 'end'
                    };
                };
                
                FrogOS.fdp({
                    url: 'assignment/getAssigned',
                    path: '/api/fdp/1/',
                    data: data
                }).done(function(response) {
                    var assignments = response.response.assignments;

                    $.each(assignments, function(index, assignment) {
                        var dueDate = assignment.assignment.end;

                        if (assignment.user_info.completed === null) {
                            assList.append(
                                self.view('row.ejs', {
                                    teacher: assignment.creator.displayname,
                                    subject: assignment.assignment.subject.name,
                                    title: assignment.assignment.name,
                                    completed: assignment.activities.complete,
                                    total: assignment.activities.total,
                                    due: moment.unix(dueDate).format(self.prefs.dateFormat.value),
                                    link: assignment.assignment.link,
                                    uuid: index
                                })
                            );

                            if (dueDate < endOfToday) {
                                assList.find('.'+index).find('.date').css('background', '#FF0000');
                                if (dueDate > startOfToday) {
                                    assList.find('.'+index).find('.date').css('background', '#F68E20');
                                    assList.find('.'+index).find('.date').html(self._('widget.placeholder.today'));
                                }
                            }
                        }
                    });                    
                    
                }).fail(function(e) {
                    // Report Error
                    console.log('failed to load assignments');
                });            
            }  
        },
        
        '.row click': function(ev) {
            var self = this;
            self.element.trigger('os.app.siteviewer', {
                data: { site: ev[0].dataset.link }
            });  
        },
        
        'widget.edit': function(el, ev, data) {
            this.element.html(
                this.view('./widget.ejs')
            );
        },

        'widget.updated': function(el, ev, data) {}
    });
});
