Com.Frog.Utils.require(
    '//package/widgets/D957482C2001B62327EBEFC7356A310096D045ACC90019FE/assets/styles/main.css',
    '//package/widgets/D957482C2001B62327EBEFC7356A310096D045ACC90019FE/assets/views/main.ejs',
    '//package/widgets/D957482C2001B62327EBEFC7356A310096D045ACC90019FE/widget.ejs'
).then(function() {
    Com.Frog.Controllers.Widget.extend('Widget.Hotspotforwebsite', {
    }, {
        prefs: {
            image: {
                type: 'upload',
                label: 'Upload same image as hotspot',
                defaultValue: '',
            },
            height: {
                type: 'number',
                label: 'Height',
                defaultValue: 'auto',
                showUnits: 'px',
                width: '32px',
                min: 200,
                max: 2000,
                inline: true,
                canAuto: true
            },
            hsUuid: {
                type: 'text',
                label: 'Hotspot Image Source',
                defaultValue: '',
                accordion: 'Advanced'
            },
            loadDelay: {
                type: 'number',
                label: 'Loading delay for replacement hotspot',
                showUnits: 'seconds',
                defaultValue: 5,
                width: '32px',
                accordion: 'Advanced'
            },
            showHotspots: {
                type: 'radio',
                label: 'Hotspot display',
                vertical: true,
                options: {
                    'No indication': 'none',
                    'Show highlight on hover': 'highlight_hover',
                    'Show border on hover': 'border_hover',
                    'Show border permanently': 'border_always'
                },
                defaultValue: 'none',
                publish: [],
                accordion: 'Design'
            }
        },

        packageID: 'D957482C2001B62327EBEFC7356A310096D045ACC90019FE',

        init: function() {},

        'widget.live': function(el, ev, data) {
            var self = this;
            if (self.prefs.hsUuid.value !== '' && self.prefs.image.value !== '') {
                var hotspotImageUUID = self.prefs.hsUuid.value.replace('file/resource/','');
                var baseURL = Frog.Utilities.getBaseUrl();
                var resource = {};

                resource.uuid = hotspotImageUUID;
                steal.import('frogui/modules/preview/preview!frog-component').then(function() {
                    self.element.html(
                        $('<div></div>').frogui_modules_preview({
                            type: 'hotspot',
                            resource: resource,
                            maxHeight: self.prefs.height.value !== 'auto' ? self.prefs.height.value : undefined
                        })
                    );
                    setTimeout(function() {
                        self.element.find('img').attr('src', baseURL+'/app/'+self.prefs.image.value);
                        
                        if (self.prefs.showHotspots.value !== 'none') {
                            self.element.find('.hotspot_hotspot').addClass(self.prefs.showHotspots.value);
                        }
                        
                    }, self.prefs.loadDelay.value*1000);
                });
            } else {
                self.element.html(
                    self.view('./widget.ejs')
                );
                self.element.find('.note').hide();
            }
        },
        
        '.bookmarklet click': function (event,target) {
            var hotspotImg = this.element.closest('.sites_pages').find('.widget_hotspot').find('img').attr('src');
            this.prefs.hsUuid.value = hotspotImg;
        },

        'widget.edit': function(el, ev, data) {
            this.element.html(
                this.view('./widget.ejs')
            );
        },
        'widget.save': function(el, ev, data) {
            this.element.html(
                this.view('./widget.ejs')
            );
        },

        'widget.updated': function(el, ev, data) {}
    });
});
