Com.Frog.Utils.require(
    '//package/widgets/ADA77B022001BC5005559FF6B69D3303B729B0AC71E2DD36/assets/styles/main.css',
    '//package/widgets/ADA77B022001BC5005559FF6B69D3303B729B0AC71E2DD36/assets/views/main.ejs',
    '//package/widgets/ADA77B022001BC5005559FF6B69D3303B729B0AC71E2DD36/widget.ejs'
).then(function() {
    Com.Frog.Controllers.Widget.extend('Widget.TelephoneLink', {
    }, {
        prefs: {
            telephone: { 
                type: 'number',
                label: 'Telephone Number',
                defaultValue: ''
            },
            telephonetext: { 
                type: 'text',
                label: 'Button label',
                defaultValue: ''
            },
            icon: {
                type: 'list',
                label: 'Icon',
                defaultValue: 'phone',
                options: {
                    'Phone': 'phone',
                    'Phone Square': 'phone-square',
                    'Mobile phone': 'mobile',
                    'School': 'university',
                    'Home': 'home',
                    'Bell': 'bell',
                    'Question': 'question-circle',
                    'Information': 'info',
                    'Information (circled)': 'info-circle',
                    'No icon': ''
                }
            },
            look: {
                type: 'list',
                label: 'Button style',
                defaultValue: 'main',
                options: {
                    'Text': 'main',
                    'Lozenge': 'lozenge',
                    'Tile': 'tile'
                }
            },
            fontsize: {
                type: 'number',
                defaultValue: 12,
                showUnits: 'pt',
                label: 'Test Size',
                accordion: 'Advanced settings'
            },
            fontcolor: {
                type: 'colourpicker',
                defaultValue: '#000000',
                label: 'Link colour',
                accordion: 'Advanced settings'
            },
            desc: {
                type: 'text',
                defaultValue: 'Telephone Number',
                label: 'Description (only visible with Lozenge look)',
                accordion: 'Advanced settings'
            },
        },

        packageID: 'ADA77B022001BC5005559FF6B69D3303B729B0AC71E2DD36',
        /**
         * Constructor. Runs when the widget is first loaded.
         *
         * @method init
         */
        init: function() {},

        /**
         * Event fired by the Site Controller.
         *
         * @event 'widget.live'
         */
        'widget.live': function(el, ev, data) {
            this.renderInEdit('live');
        },
        'widget.edit': function(el, ev, data) {
            this.renderInEdit('edit');
        },
        'widget.save': function(el, ev, data) {
            this.renderInEdit('edit');
        },
        renderInEdit : function(mode) {
            var text = "",
                ejs = this.prefs.look.value;    
            if (this.prefs.telephonetext.value == '') {
                text = this.prefs.telephone.value;
            } else {
                text = this.prefs.telephonetext.value;
            };
            if (this.prefs.telephone.value == '') {
                text = "No telephone number set";
            }
            this.element.html(
                this.view(ejs+'.ejs', {
                    telephone: this.prefs.telephone.value,
                    text: text,
                    icon: this.prefs.icon.value,
                    desc: this.prefs.desc.value
                })
            );
            this.element.find('.calllink').css('color',this.prefs.fontcolor.value);
            this.element.find('.packaged-widget-placeholder--container').css('font-size',this.prefs.fontsize.value+'pt');
            if (mode=='edit') {
                this.element.find('.calllink').removeAttr('href');
            }
        }
    });
});