Com.Frog.Utils.require(
    '//package/widgets/341D6B962001BA45946C5F3FE1E4B70B78F0438CA3321A97/assets/styles/main.css',
    '//package/widgets/341D6B962001BA45946C5F3FE1E4B70B78F0438CA3321A97/assets/views/main.ejs',
    '//package/widgets/341D6B962001BA45946C5F3FE1E4B70B78F0438CA3321A97/widget.ejs'
).then(function() {
    Com.Frog.Controllers.Widget.extend('Widget.TaskRandomiser', {
    }, {
        prefs: {

            "task1": {
                type:"text",
                defaultValue:"Make a PowerPoint presentation",
                label:"Task 1"
            },
            "task2": {
                type:"text",
                defaultValue:"Design a poster",
                label:"Task 2"
            },
            "task3": {
                type:"text",
                defaultValue:"Create an animation",
                label:"Task 3"
            },
            "task4": {
                type:"text",
                defaultValue:"Draw a storyboard",
                label:"Task 4"
            },
            "task5": {
                type:"text",
                defaultValue:"Make a quiz for your classmates",
                label:"Task 5"
            },
            "task6": {
                type:"text",
                defaultValue:"",
                label:"Task 6"
            },
            "task7": {
                type:"text",
                defaultValue:"",
                label:"Task 7"
            },
            "task8": {
                type:"text",
                defaultValue:"",
                label:"Task 8"
            },
            "task9": {
                type:"text",
                defaultValue:"",
                label:"Task 9"
            },
            "task10": {
                type:"text",
                defaultValue:"",
                label:"Task 10"
            }
        },

        packageID: '341D6B962001BA45946C5F3FE1E4B70B78F0438CA3321A97',
        /**
         * Constructor. Runs when the widget is first loaded.
         *
         * @method init
         */
        init: function() {},

        /**
         * Event fired by the Site Controller.
         *
         * @event 'widget.live'
         */
        'widget.live': function(el, ev, data) {
            this.element.html(
                this.view('main.ejs')
            );
            var taskArray= [
                    this.prefs.task1.value,
                    this.prefs.task2.value,
                    this.prefs.task3.value,
                    this.prefs.task4.value,
                    this.prefs.task5.value,
                    this.prefs.task6.value,
                    this.prefs.task7.value,
                    this.prefs.task8.value,
                    this.prefs.task9.value,
                    this.prefs.task10.value
                ],
                taskDisplay = this.element.find('.taskDisplay'),
                nIntervId,
                pick = this.element.find('.pick'),
                strt = this.element.find('.start'),
                i=0,
                p=0;
            // Removes empty entries
            taskArray = jQuery.grep(taskArray, function(n){ return (n); });

            function Shuffle(o) {
                for(var j, x, i = o.length; i; j = parseInt(Math.random() * i), x = o[--i], o[i] = o[j], o[j] = x);
                return o;
            }
            Shuffle(taskArray);

            pick.hide();

            strt.click(function() {
                pick.show();
                strt.hide();
                nIntervId = setInterval(function() {

                        taskDisplay.text(taskArray[i]);
                        i++;
                        if (i>taskArray.length-1) {
                            i=0;
                        }
                }.bind(this), 60);
            });

            pick.click(function() {
                window.clearInterval(nIntervId);
                taskDisplay.text(taskArray[p]);
                p++;
                strt.show();
                pick.hide();
                if (p>taskArray.length-1) {
                    p=0;
                    Shuffle(taskArray);
                }
            });

        },

        /**
         * Event fired by the Site Controller. Tells the widget that the site is in Edit Mode.
         *
         * @event 'widget.edit'
         */
        'widget.edit': function(el, ev, data) {
            window.clearInterval(this.nIntervId);
            this.element.html(
                this.view('./widget.ejs')
            );
        }
    });
});