Com.Frog.Utils.require(
    '//package/widgets/AB497F462001B26B1A49BF2C91379A0968BA2FDC3FC7D8C7/assets/styles/main.css',
    '//package/widgets/AB497F462001B26B1A49BF2C91379A0968BA2FDC3FC7D8C7/assets/views/main.ejs',
    '//package/widgets/AB497F462001B26B1A49BF2C91379A0968BA2FDC3FC7D8C7/assets/views/info.ejs',
    '//package/widgets/AB497F462001B26B1A49BF2C91379A0968BA2FDC3FC7D8C7/assets/views/list.ejs',
    '//package/widgets/AB497F462001B26B1A49BF2C91379A0968BA2FDC3FC7D8C7/assets/views/sitelink.ejs',
    '//package/widgets/AB497F462001B26B1A49BF2C91379A0968BA2FDC3FC7D8C7/assets/views/table.ejs',
    '//package/widgets/AB497F462001B26B1A49BF2C91379A0968BA2FDC3FC7D8C7/assets/views/tablerow.ejs',
    '//package/widgets/AB497F462001B26B1A49BF2C91379A0968BA2FDC3FC7D8C7/widget.ejs'
).then(function() {
    Com.Frog.Controllers.Widget.extend('Widget.Favourites', {
    }, {
        prefs: {
            title: {
                type: 'text',
                label: 'Widget title',
                defaultValue: 'My Favourite sites'
            },
            look: {
                type: 'radio',
                label: 'Select list type',
                vertical: true,
                options: {
                    'Site Links': 'sitelink.ejs',
                    'Bullet Points': 'list.ejs',
                    'Table': 'tablerow.ejs'
                },
                defaultValue: "sitelink.ejs",
                publish: []
            },
            fontSize: {
                type: 'number',
                label: 'Font size',
                defaultValue: 19,
                showUnits: 'px',
                accordion: 'Text options'
            },
            fontColour: {
                type: 'colourpicker',
                label: 'Link colour',
                defaultValue: '#ff0000',
                accordion: 'Text options'
            },
            setFixedHeight: {
                type: 'height',
                label: 'Height (px)',
                placeholder: 'placeholder text',
                options: {
                    on_text: 'auto',
                    off_text: 'manual'
                },
                defaultValue: 300
            }
        },
        editMode: true,
        packageID: 'AB497F462001B26B1A49BF2C91379A0968BA2FDC3FC7D8C7',

        init: function() {},


        'widget.live': function(el, ev, data) {
            this.editMode = false;
            this.render();
        },
        getFavourites : function() {
            
            var clss = '.favouriteList';
            this.element.find( clss ).empty();
            if ( this.prefs.look.value == 'tablerow.ejs' ) {
                this.element.find( clss ).append( this.view('table.ejs') );
                clss = '.table';     
            };
            
            Frog.Model.api('favourites.getFavourites', {
                type: 'site'
            }).done(function(sitesResponse) {
                var sites = sitesResponse.data.site;
                if (jQuery.isEmptyObject(sites) === false ) {
                    $.each(sites, function(index,site) {                  
                        this.element.find( clss ).append(
                            this.view( this.prefs.look.value , {
                                siteTitle: site.name,
                                siteDesc: site.description,
                                siteIcon: site.icon,
                                siteurl: site.link
                            })
                         );
                    }.bind(this));
                
                    if ( this.prefs.look.value == 'list.ejs') {
                         this.element.find('.sitesList').css('font-size', this.prefs.fontSize.value+'px');
                         this.element.find('.sitesList').css('color', this.prefs.fontColour.value);
                     }
                } else {
                    this.element.find( clss ).html( this.view( 'info.ejs' ));
                }
            }.bind(this)).fail(function(e) {
                Frog.Controller.prototype.growl('Failed to find Favourites','My Favourite Sites','app-name',{time:5000, icon: 'externalapps/icon/AB497F462001B26B1A49BF2C91379A0968BA2FDC3FC7D8C7'});
            });
        },

        'widget.edit': function(el, ev, data) {
            this.editMode = true;
            this.render();
        },
        'widget.save': function(el, ev, data) {
            this.editMode = true;
            this.render();
        },
        '.mylink:not(.defavourite) click': function (event,target) {
            if (this.editMode === false) {
                this.element.trigger('widget.launch.site', {
                    site_url: event.data('siteurl')
                }); 
            }
        },
        '.refresh click': function (event,target) {
            if (this.editMode === false) {
               this.getFavourites();
            }
        },
        render: function() {
            this.element.html(
                this.view('main.ejs')
            );
            this.element.find('h4').text(this.prefs.title.value);
            
            if ( this.prefs.look.value == 'tablerow.ejs' ) {
                this.element.find('.favouriteList').append(
                    this.view( 'table.ejs' )
                )
            }         
            this.getFavourites();
           
            if ( this.prefs.setFixedHeight.value > 0) {
                this.element.find('.favouriteList').css('height', this.prefs.setFixedHeight.value+'px');
                
            }
        },

        'widget.updated': function(el, ev, data) {}
    });
});
