Com.Frog.Utils.require(
    '//package/applications/E45796BB200481BC87A61FAB6E9E6601F8D8ADBCA8073393/assets/styles/main.css',
    '//package/applications/E45796BB200481BC87A61FAB6E9E6601F8D8ADBCA8073393/assets/views/main.ejs'
).then(function() {
    Com.Frog.Controllers.Application.extend('E45796BB200481BC87A61FAB6E9E6601F8D8ADBCA8073393.Controllers.Core', {
        defaults: {}
    }, {
        packageID: 'E45796BB200481BC87A61FAB6E9E6601F8D8ADBCA8073393',

        init: function() {
            this.main();
        },

        update: function(options) {
            this._super(options);
            this.main();
        },

        main: function() {
            this.render();
        },

         render: function() {
            ///load mobile firendly view if mobile browser detected
            if (/Mobi/.test(navigator.userAgent)) {
                this.element.html(
                    this.view('mobile.ejs')
                );
            } else {
                this.element.html(
                    this.view('main.ejs')
                );                
            }


///////declare variables and initialise app//////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////
this.showLoader();            
var $myapp = this.element.find("div[data-name=seatingplanner]");          
var $canvas = $myapp.find("div[data-name=canvas]");
var baseURL = Frog.Utilities.getBaseUrl();
var file_path = baseURL + '/app/';
//var default_image = "file/resource/E4F567D420030AF07D9CEF90765C9804F5EEB84C9CCCB8A4?1497556517";
//var seated_img = "<img class=\"image\" src=\""+baseURL+"/app/file/resource/E4F56B6320030F8725BBBFAF7BC1570BC2F6D00C87CEF9DD?1497556604\">";
//var seats_img = "<img class=\"image\" src=\""+baseURL+"/app/file/resource/E4F55A0F200306280F950F14C044E304403A44ACA4C1C663?1497556628\">";
var default_image = baseURL + "/app/package/applications/E45796BB200481BC87A61FAB6E9E6601F8D8ADBCA8073393/assets/students.png";
var seated_img = "<img class=\"image\" src=\""+baseURL+"/app/package/applications/E45796BB200481BC87A61FAB6E9E6601F8D8ADBCA8073393/assets/seated.png\">";
var seats_img = "<img class=\"image\" src=\""+baseURL+"/app/package/applications/E45796BB200481BC87A61FAB6E9E6601F8D8ADBCA8073393/assets/seats.png\">";

var seats_img_bg = seats_img;
//var student_img = "<img class=\"image\" src=\""+baseURL+"/app/file/resource/E4F546832003047CB5560F1B7891B90B6463F73CB882B331?1497556649\">";
var student_img = "<img class=\"image\" src=\""+baseURL+"/app/package/applications/E45796BB200481BC87A61FAB6E9E6601F8D8ADBCA8073393/assets/students.png\">";
var isdirty = false;
var seat_margin = 3;
var seat_width = 145;
    if (/Mobi/.test(navigator.userAgent)) {
    	seat_width = 100;
    }
var mymodal;
var modal_error = false;
var currentplan = null;
var isadvanced = false;
var showContext = false;
var isflipped = false;
var student_flags_uuid = "F3A046342004C31D2202BFC5159509053172444CCD360D5F";
var site_uuid, form_uuid, field_uuid;
var prefs;

             
$myapp.find("div[data-name=groupLayout]").hide();
$myapp.find("div[data-name=groupPlan]").hide();
$myapp.find("div[data-name=groupAuto]").hide();
///////end of initialise/////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////
            
            
///////This section deals with data storage//////////////////////////////////////////////
//////currently uses frogs forms database////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////           
Frog.Model.api('sites.search', { 
    exclude_sources: ["temporary"],
    query: "FrogSeats Data",
    scope: "personal",
    requires: {columns: "false"}
}).done(function(firstresp) {
    if (firstresp.data.sites.length === 0) {
        //create site and then form
        return Frog.Model.api('sites.create', {
            name: "FrogSeats Data",
            description: "DO NOT DELETE!",
            quiet: true,
            page:"[]",
            theme:"973D2A782002CA61EC425F9935BCA4020F2087FC6AB5FDCA" 
        },
        {
            type: 'POST'
        }).done(function(resp) {
            site_uuid = resp.data.site.uuid;
            return Frog.Model.api('form.create', {
                name: "frogSeats"+resp.data.site.uuid,
                description: "",
                label_align: "top",
                type: "form",
                site_uuid: resp.data.site.uuid,
                fields: [{label: "j", sequence: "0", type: "textarea", value: "j"}]
            },
            {
                type: 'POST'
            }).done(function(resp) {
                form_uuid = resp.data.uuid;
                field_uuid = resp.data.fields[0].uuid;
                this.hideLoader();
            }.bind(this));
        }.bind(this));
    } else {
        //get site uuid
        site_uuid = firstresp.data.sites[0].uuid;
        return Frog.Model.api('form.search', { 
            force: true,
            query: "frogSeats"+firstresp.data.sites[0].uuid,
            template: false,
            type: "form"
        }).done(function(resp) {
            form_uuid = resp.data[0].uuid;
            //now get the fields
            return Frog.Model.api('form.get', {
                summary: true,
                uuid: resp.data[0].uuid
            }).done(function(resp) {
                field_uuid = resp.data.fields[0].uuid;
                if (resp.data.responded_data.length === 0) {
                    //there is nothing here yet!
                } else {
                    //some saved data already exists
                    var mydata = JSON.parse(resp.data.responded_data[0].response.fields[0].responses[0].response);
                    if (mydata.hasOwnProperty("prefs")) {
                        prefs = mydata.prefs;
                    } else {
                        prefs = [{
                            sorting: "forename",
                            view: ["pupil_premium", "sen"]
                        }];
                    }
                    mydata.layouts.forEach(function(layout) {
                        $myapp.find("[data-name=rmlayout]").append("<div data-name=\""+layout.guid+"\" data-config=\'{\"guid\":\""+layout.guid+"\", \"name\":\""+layout.name+"\",\"width\":"+layout.width+",\"height\":"+layout.height+",\"seats\":["+layout.seats+"]}\' class=\"rmlayout\"><table><tr><td>CUSTOM LAYOUT<br />"+decodeURIComponent(layout.name).replace(/%27/g, '\'')+"</td><td>"+seats_img_bg+layout.seats.length+"</td></tr></table></div>");
                    });
                    
                     mydata.plans.forEach(function(plan) {
                        $myapp.find("div[data-name=plans]").append("<div class=\"seatplandivider\"><div data-name=\"S"+plan.guid+"\" class=\"stplan\" data-config=\'{\"guid\":\""+plan.guid+"\", \"name\":\""+plan.name+"\",\"width\":"+plan.width+",\"height\":"+plan.height+",\"layout_guid\":\""+plan.layout_guid+"\",\"layout_name\":\""+plan.layout_name+"\",\"class_uuid\":\""+plan.class_uuid+"\",\"class_name\":\""+plan.class_name+"\",\"seats\":["+plan.seats+"],\"plan\":"+JSON.stringify(plan.plan)+"}\'><table><tr><td>Plan: "+decodeURIComponent(plan.name).replace(/%27/g, '\'')+"</td><td>"+seats_img+plan.seats.length+"</td></tr><tr><td>Class: "+plan.class_name+"</td><td>"+student_img+"</td></tr><tr><td>Layout: "+decodeURIComponent(plan.layout_name).replace(/%27/g, '\'')+"</td><td>"+seated_img+plan.plan.length+"</td></tr></table></div><div data-name=\"L"+plan.guid+"\" class=\"seatplanclasslist\"></div></div>");
							loadclass(plan.class_uuid,"L"+plan.guid,true);
                    });
                }
                this.hideLoader();
            }.bind(this));
        }.bind(this));
    }
}.bind(this));
//////end of data stroage////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////             

          
///////////////begin auto helper buttons///////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////////  
$myapp.find("div[data-name=myslider]").slider({
        min: 0.1,max: 1.9,step: 0.1,value: 1,
      	slide: function( event, ui ) {
          var newCss = { 'zoom' : ui.value };
          if('WebkitTransform' in document.body.style) {
              newCss = { '-webkit-transform': 'scale(' + ui.value + ')', '-webkit-transform-origin': 'top left'};
          }
          else if('transform' in document.body.style) {
              newCss = { 'transform': 'scale(' + ui.value + ')', 'transform-origin': 'top left'};
          }
        $myapp.find('div[data-name=canvas]').css(newCss);
      }
    });
            
$myapp.find("[data-name=autoEmpty]").click(function () {
    var activecontainer = $myapp.find(".stplan.appactive").data("name").slice(1);
    $myapp.find("div[data-type=space].seat_selected").each( function(i,e) {
        if($(e).children().length !== 0) {
            //var myid = $(e).children(":first").data("name");
            var myid = $(e).find('table').data('name');
            $myapp.find("div[data-name=L"+activecontainer+"] .student [data-name="+myid+"]").parent().show();
            $(e).empty();
        }
    });
    $myapp.find("div[data-name=L"+activecontainer+"] .seatedmsg").remove();
    $myapp.find("div[data-name=S"+activecontainer+"] tr:eq(2) td:eq(1)").html(seated_img+"0");
    checkDirty(true);	
});            
                 
$myapp.find("[data-name=autoAlpha]").click(function () {
    $myapp.find("[data-name=autoEmpty]").trigger("click");
    var activecontainer = $myapp.find(".stplan.appactive").data("name").slice(1); 
   $myapp.find("div[data-name=L"+activecontainer+"] .student:visible").each(function(i, obj) {
       $allmatches = $myapp.find("div[data-type=space].seat_selected:empty:first");
        if ($allmatches.length ) {
            $allmatches.html(obj.innerHTML);
            //$allmatches.html(obj.outerHTML);
            $(obj).hide();
        }
    });
    $myapp.find("div[data-name=S"+activecontainer+"] tr:eq(2) td:eq(1)").html(seated_img+$myapp.find("div[data-name=L"+activecontainer+"] .student").length);
    checkAllSeated("L"+activecontainer);
    checkDirty(true);
});            
            
$myapp.find("[data-name=autoRandom]").click(function () {
	$myapp.find("[data-name=autoEmpty]").trigger("click");
	var activecontainer = $myapp.find(".stplan.appactive").data("name").slice(1);
	$myapp.find("div[data-name=L"+activecontainer+"] .student:visible").each(function(i, obj) {
		randomElement = $myapp.find("div[data-type=space].seat_selected:empty").get().sort(function(){ 
			return Math.round(Math.random())-0.5;
		}).slice(0,1);
		if ($(randomElement).length) {
			$(randomElement).html(obj.innerHTML);
            //$(randomElement).html(obj.outerHTML);
			$(obj).hide();
		}   
		});
     $myapp.find("div[data-name=S"+activecontainer+"] tr:eq(2) td:eq(1)").html(seated_img+$myapp.find("div[data-name=L"+activecontainer+"] .student").length);
    checkAllSeated("L"+activecontainer);
	checkDirty(true);
});
                     
$myapp.find("[data-name=autoGender]").click(function () {
	$myapp.find("[data-name=autoEmpty]").trigger("click");
	var activecontainer = $myapp.find(".stplan.appactive").data("name").slice(1);
    var $girls = $myapp.find("div[data-name=L"+activecontainer+"] .student[data-gender=female]:visible");
    var $boys = $myapp.find("div[data-name=L"+activecontainer+"] .student[data-gender=male]:visible");
    var y = Math.max($girls.length, $boys.length);
    for (var i = 0; i < y; i++) {
        var $girl = $girls.eq(i);
        var $boy = $boys.eq(i);
        if ($girls.length > $boys.length) {
            if ($girl) {
                if ($myapp.find("div[data-type=space].seat_selected:empty:first").length) {
                    $myapp.find("div[data-type=space].seat_selected:empty:first").html($girl.html());
                    //$myapp.find("div[data-type=space].seat_selected:empty:first").html($girls[i].outerHTML);
                    $girl.hide();
                }
            }
            if ($boy) {
                if ($myapp.find("div[data-type=space].seat_selected:empty:first").length) {
                    $myapp.find("div[data-type=space].seat_selected:empty:first").html($boy.html());
                   // $myapp.find("div[data-type=space].seat_selected:empty:first").html($boys[i].outerHTML);
                    $boy.hide();
                }
            }	
        } else {	
            if ($boy) {
                if ($myapp.find("div[data-type=space].seat_selected:empty:first").length) {
                    $myapp.find("div[data-type=space].seat_selected:empty:first").html($boy.html());
                    //$myapp.find("div[data-type=space].seat_selected:empty:first").html($boys[i].outerHTML)
                    $boy.hide();
                }
            }
            if ($girl) {
                if ($myapp.find("div[data-type=space].seat_selected:empty:first").length) {
                    $myapp.find("div[data-type=space].seat_selected:empty:first").html($girl.html());
                   // $myapp.find("div[data-type=space].seat_selected:empty:first").html($girls[i].outerHTML);
                    $girl.hide();
                }
            }
        }	
    }
	$myapp.find("div[data-name=S"+activecontainer+"] tr:eq(2) td:eq(1)").html(seated_img+$myapp.find("div[data-name=L"+activecontainer+"] .student").length);
    checkAllSeated("L"+activecontainer);
    checkDirty(true);	
});            
///////////////end auto helper buttons/////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////////            
            
            
///////////////other toolbar buttons///////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////////                     
$myapp.find("button[data-name=reveal]").click(function(obj) {
showContext = !showContext;
    if (showContext) {
        $(obj.target).removeClass("btn-primary").addClass("btn-danger");
    	var active_class = $myapp.find(".stplan.appactive").data("name").slice(1);
    	var requests;
        
    	if ($myapp.find("div[data-name=L"+active_class+"] .student:first").children(":first").data("context") === undefined) {
            this.showLoader();
   		 requests = $myapp.find("div[data-name=L"+active_class+"] .student").map(function(i,e) {
    	 var member_uuid = $(e).children(":first").data("name");
        
        	return Frog.Model.api('users.getDataInCategory', { user_uuid: member_uuid, uuid: student_flags_uuid })
                .done(function(resp) {
                    var fields = resp.data.fields;
					var member = {};
                    fields.forEach(function(field) {
                        if (field.label !== "ethnicity") {
                        	member[field.label] = field.value;
                        }
               		});
                $myapp.find("[data-name=L"+active_class+"] .student [data-name="+member_uuid+"]").data("context", member);
           		});
    	});
    	jQuery.when.apply(this, requests)
        	.done(function() {
        		showContextualData(active_class);
        		this.hideLoader();
    	}.bind(this));
    	} else {
        	//$myapp.find("span.context").show();
            showContextualData(active_class);
    	}
    } else {
        $(obj.target).removeClass("btn-danger").addClass("btn-primary");
        $myapp.find("span.context").hide();
    } 
}.bind(this));               
            
$myapp.find("button[data-name=savePlan]").click(function() {
    var ids = [];
    var seats = [];
    $canvas.find(".seat_selected").each( function(i,e) {
        seats.push($(e).data("name"));
        if ($(e).children().length !== 0) {
        	ids.push(""+$(e).data("name") + "-" + $(e).children(":first").data("name")+"");
        }
    });
    var myjson = $myapp.find(".stplan.appactive").data("config");
    $myapp.find(".stplan.appactive").data("config", { guid: myjson.guid, name: myjson.name, width: myjson.width, height: myjson.height, layout_guid: myjson.layout_guid, layout_name: myjson.layout_name, class_uuid: myjson.class_uuid, class_name: myjson.class_name, seats: seats, plan: ids });
    checkDirty(false);
    gloabl_save();
});   

$myapp.find("[data-name=editPlan]").click(function() {
        mymodal = edit_plan.getInstance(this);
        this.element.find(".modal input[type=text]:eq(0)").val( decodeURIComponent($myapp.find(".stplan.appactive").data("config").name).replace(/%27/g, '\'') );
}.bind(this));   
             
             
             $myapp.find("[data-name=editPrefs]").click(function() {
                 mymodal = edit_prefs.getInstance(this);
                 this.element.find(".modal-body [data-action=mymodal-sorting]").val(prefs[0].sorting);
                 prefs[0].view.forEach(function(view) {
                    this.element.find(".modal #"+view).prop('checked', true);   
                 }.bind(this));
             }.bind(this)); 
             
            
$myapp.find("[data-name=printPlan]").click(function () {
   	var plan = $myapp.find(".stplan.appactive").data("config");	
 	var html = $myapp.find("div[data-name=projection]").html();
    var win = window.open();
	$(win.document).attr("title", "FrogSeats Print Version of Your Plan");
	$(win.document.head).append('<style type="text/css">body{font-size:0.9em;font-family:Arial,Helvetica,sans-serif;}table,tr,td,th,tbody{font-size:small;margin:0;padding:0;border:0;border-spacing:0;width:100%;}div[data-name="zoom"]{visibility:hidden;}div[data-type="space"]{visibility:hidden;}div[data-type="space"]{box-sizing:border-box;float:left;height:65px;}div[data-type="space"].seat_selected{visibility:visible;border:1px black solid;padding:3px 3px 3px 3px;}.clip-circle{background-repeat:no-repeat;background-size:50px;background-color:white;height:50px;width:50px;border-radius:50%;border:1px black solid;overflow:hidden;margin:0px 0px 0px 0px;}.title{font-size:medium;font-weight:bold;}</style>');

    var title = "<div class=\"title\">Seating plan for class: "+plan.class_name+"<br />Plan name: "+decodeURIComponent(plan.name).replace(/%27/g, '\'');
    		if (isflipped) {		
    			title = title + " (rotated)</div><br />";
            } else {
    			title = title + "</div><br />";
            }
    	$(win.document.body).append(title);
    	$(win.document.body).append(html);
    
    for (var x = plan.width; x > 0; x--) {
		var checkvar = true;
		for (var i = x; i <= plan.width*plan.height; i+=plan.width) {
    		if ($(win.document.body).find("div[data-name="+i+"]").hasClass("seat_selected")) {
    			checkvar = false;
            	x = -1;
            	i = plan.width*plan.height;
    		}
		}
		if (checkvar) {
			for (i = x; i <= plan.width*plan.height; i+=plan.width) {
    			$(win.document.body).find("div[data-name="+i+"]").remove();
			}
		var canvas_width = $(win.document.body).find("div[data-name=canvas]").width();
		$(win.document.body).find("div[data-name=canvas]").width((canvas_width-(seat_width+seat_margin+seat_margin)));
		}
	}
    for (x = plan.height; x > 0; x--) {
		var checkvar = true;
    	var z = 1+((x-1)*plan.width);
		for (var i = z; i <= z+plan.width-1; i++) {
    		if ($(win.document.body).find("div[data-name="+i+"]").hasClass("seat_selected")) {
    			checkvar = false;
            	x = -1;
            	i = z+plan.width;
    		}
		}
    	if (checkvar) {
			for (i = z; i <= z+plan.width-1; i++) {
    			$(win.document.body).find("div[data-name="+i+"]").remove();
			}
         $(win.document.body).find("div[data-name=canvas]").css("height", "");
		}
	}
//win.print();
});

$myapp.find("button[data-name=saveLayout]").click(function(e) {
    var ids = [];
    $('.seat_selected').each( function(i,e) {
        ids.push($(e).data("name"));
    });
    var myjson = $myapp.find(".rmlayout.appactive").data("config");
    $myapp.find(".rmlayout.appactive").data("config", { guid: myjson.guid, name: myjson.name, width: myjson.width, height: myjson.height, seats: ids });
    checkDirty(false);
    gloabl_save();
});      
      
$myapp.find("button[data-name=editLayout]").click(function(obj) {
    if (isdirty === true) {
    $myapp.find("button[data-name=savePlan]").trigger("click");
     }
    	isadvanced = !isadvanced;
    	if (isadvanced === true) {
          $myapp.find("div[data-name=sidebar]").append($.ui.dialog.overlay.create());
           $myapp.find("div[data-name=groupAuto]").hide();
            $(obj.target).removeClass("btn-primary").addClass("btn-warning");
            $canvas.find("div[data-type=space].seat_selected").draggable( 'destroy' );
             $canvas.find("div[data-type=space].seat_selected").droppable( 'destroy' );
            $canvas.find("div[data-type=space]").attr("data-type", "seat");
        } else {
          $myapp.find("div[data-name=sidebar] .ui-widget-overlay").remove();
             $myapp.find("div[data-name=groupAuto]").show(); 
             $(obj.target).removeClass("btn-warning").addClass("btn-primary");
            $canvas.find("div[data-type=seat]").attr("data-type", "space");
            doDragandDrop();
        }
});            
            
$myapp.find("[data-name=rotatePlan]").click(function (obj) {
     if (isdirty === true) {
    $myapp.find("button[data-name=savePlan]").trigger("click");
     }
    if (isadvanced) {
     $myapp.find("button[data-name=editLayout]").trigger("click");
    }
    	isflipped = !isflipped;
    	var config = $myapp.find(".stplan.appactive").data("config");
        var total_seats = config.width * config.height;
    	$canvas.empty();	
    	if (isflipped === true) {
            $(obj.target).removeClass("btn-primary").addClass("btn-warning");
            		for (var i = total_seats; i > 0; i--) {
            			$canvas.append("<div data-type=\"space\" data-name=\""+(i)+"\"></div>");
            		}
        } else {
            $(obj.target).removeClass("btn-warning").addClass("btn-primary");
            		 for (var i = 0; i < total_seats; i++) {
            			$canvas.append("<div data-type=\"space\" data-name=\""+(i+1)+"\"></div>");
            		}
        }
    $.each(config.seats, function(key, value) {
        $canvas.find("div[data-name="+value+"]").addClass("seat_selected");
    });
    $canvas.find("div").css({"width" : seat_width, "margin" : seat_margin});
   seatstudents();
   doDragandDrop();
});                  
///////////////end of other toolbar buttons////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////////             

//////canvas click functions////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////////////               
$canvas.on("click", "div[data-type=seat]", function(ev) {
    checkDirty(true);
    $(ev.currentTarget).toggleClass("seat_selected");
    if (isadvanced === true) {
            if($(ev.currentTarget).children().length !== 0) {
                var rid = $(ev.currentTarget).children(":first").data("name");
                var activecontainer = $('.stplan.appactive').data("name").slice(1);
                $myapp.find("div[data-name=L"+activecontainer+"] .student [data-name="+rid+"]").parent().show();
                $(ev.currentTarget).empty();
                var currentcount = parseInt($myapp.find("div[data-name=S"+activecontainer+"] tr:eq(2) td:eq(1)").text());
                $myapp.find("div[data-name=S"+activecontainer+"] tr:eq(2) td:eq(1)").html(seated_img+(currentcount-1));
            }
        $myapp.find(".stplan.appactive table tr:eq(0) td:eq(1)").html(seats_img+$myapp.find("div[data-type=seat].seat_selected").length);
    } else {
        $myapp.find(".rmlayout.appactive table td:eq(1)").html(seats_img_bg+$myapp.find("div[data-type=seat].seat_selected").length);
    }
});
//////end of canvas click functions/////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////////////        
            
            
////////////////////////////////////////////////////////////////////
//////plan and layout clicks//////////////////////////////////////// 
$myapp.find("div[data-name=rmlayout]").on("click", ".rmlayout", function(ev) {
    if (!$(ev.currentTarget).hasClass("appactive")) {
    	if (isdirty === true) {
        	areYouSure('save',ev.currentTarget);
        } else {
            switch_layout(ev.currentTarget);
        }
    }
});              
            
$myapp.find("div[data-name=plans]").on("click", ".stplan", function(ev) {
    if (!$(ev.currentTarget).hasClass("appactive")) {
    	if (isdirty === true) {
        	areYouSure('save',ev.currentTarget);
        } else {
            $myapp.find("div[data-name=groupLayout]").hide();
            $myapp.find("div[data-name=groupPlan]").show();
            $myapp.find("div[data-name=groupAuto]").show();
            $myapp.find(".seatplanclasslist").hide();
            $myapp.find(".appactive").removeClass("appactive");
            $(ev.currentTarget).addClass("appactive");
            currentplan = $(ev.currentTarget).data("name").slice(1);
            var listcontainer = 'L'+currentplan;
            $myapp.find("div[data-name="+listcontainer+"]").show();
            Layout_Room($(ev.currentTarget).data("config"),'plan');
            if($myapp.find("div[data-name="+listcontainer+"]").text().length === 0) {
				loadclass($(ev.currentTarget).data("config").class_uuid, listcontainer);	
			} else {
               doDragandDrop();
				seatstudents();	
			}
        }
    }
});   
            
$myapp.find("button[data-name=newPlan]").click(function(ev) {
    if (isdirty === true) {
        areYouSure('save',ev.currentTarget);
    } else {
        if ($myapp.find(".appactive").length > 0) {
        $myapp.find("div[data-name=L"+$myapp.find(".appactive").data("name").slice(1)+"]").hide();
    	}
        $myapp.find("div[data-name=groupPlan]").hide();
        $myapp.find("div[data-name=groupAuto]").hide();
        $myapp.find("div[data-name=groupLayout]").hide();
        $myapp.find(".appactive").removeClass("appactive");
        $canvas.empty();
        //var classes = '';
        //FrogOS.getUser().groups.each(function(i,group) {
        //    if (group.type.type === 'class') {
        //        classes += "<option value=\""+group.uuid+"\">"+group.name+"</option>";
        //    }
        //});
        var usersclasses = '';
        FrogOS.getUser().groups.each(function(i,group) {
            if (group.type.type === 'class') {
                firstclass = group.name;
                firstclass_uuid = group.uuid;
                usersclasses += '<li class="single-class group" data-value="'+group.uuid+'"><a href="#"><span title="'+group.name+'"><i>Group: </i><strong>'+group.name+'</strong></span></a></li>';
            }
        });
        //////for testing make sure test staff acount has one class
        //if (usersclasses.length === 0) {
            //classes += "<option value=\"D598F81F200134F82D28FFDC42355C0DDE718EEC3C878CE0\">Test class</option>";
            //usersclasses += '<li class="single-class group" data-value="D598F81F200134F82D28FFDC42355C0DDE718EEC3C878CE0"><a href="#"><span title="Test class"><i>Group: </i><strong>Test class</strong></span></a></li>';
        //}
        ///////////////////////////////////////////////////////////////
        var rmlayouts = '';
        $myapp.find("div[data-name=rmlayout] .rmlayout").each(function(i,ele) {
            rmlayouts += "<option value=\""+$(ele).data('config').guid+"\">"+decodeURIComponent($(ele).data('config').name).replace(/%27/g, '\'')+"</option>";
        });
        if (usersclasses.length > 0 && rmlayouts.length > 0) {
        mymodal = new_plan.getInstance(this);
        //this.element.find(".modal select:eq(0)").html(classes);
        this.element.find(".modal input[type=text]:eq(0)").css("border-color", "red");
        this.element.find(".modal .my-classes").append(usersclasses);    
        this.element.find(".modal select:eq(0)").html(rmlayouts);
        this.element.find(".modal select:eq(0)").css("border-color", "green");
        this.element.find(".modal input[type=text]:eq(1)").css("border-color", "red");
        this.element.find(".modal button[data-action=mymodal-plan-save]").prop('disabled', true);
       // this.element.find(".modal input[type=text]:eq(0)").val(this.element.find(".modal select:eq(0) option:selected").text()+'-'+this.element.find(".modal select:eq(1) option:selected").text());        
        } else {
            areYouSure('deny_plan');
        }   
    }
}.bind(this));           
            
$myapp.find("button[data-name=saveNewLayout]").click(function(ev) {
 if (isdirty === true) {
        areYouSure('save',ev.currentTarget);
    } else {
        var myjson = $myapp.find(".rmlayout.appactive").data("config");
        mymodal = new_layout.getInstance(this);
        this.element.find(".modal input[type=text]:first").val('copy of '+decodeURIComponent(myjson.name).replace(/%27/g, '\''));
        this.element.find(".modal select:eq(0)").val(myjson.width);
        this.element.find(".modal select:eq(0)").attr('disabled',true);
        this.element.find(".modal select:eq(1)").val(myjson.height);
        this.element.find(".modal select:eq(1)").attr('disabled',true);
        this.element.find(".modal input[type=hidden]:first").val(myjson.seats);
    }
}.bind(this));
               
$myapp.find("button[data-name=newLayout]").click(function(ev) {
    if (isdirty === true) {
        areYouSure('save',ev.currentTarget);
    } else {
        if ($myapp.find(".appactive").length > 0) {
        $myapp.find("div[data-name=L"+$myapp.find(".appactive").data("name").slice(1)+"]").hide();
        }
        $myapp.find("div[data-name=groupPlan]").hide();
        $myapp.find("div[data-name=groupAuto]").hide();
        $myapp.find("div[data-name=groupLayout]").hide();
        $myapp.find(".appactive").removeClass("appactive");
        $canvas.empty();
        mymodal = new_layout.getInstance(this);
        this.element.find(".modal input[type=text]:first").focus();
    }
}.bind(this));            
////////////end of plan and layout clicks/////////////////////////////////
//////////////////////////////////////////////////////////////////////////
 
            
////////////delete clicks/////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////            
$myapp.find("button[data-name=deleteLayout]").click(function(ev) {
    areYouSure('delete');
});
$myapp.find("button[data-name=deletePlan]").click(function(ev) {
    areYouSure('delete');
});            
////////////end of delete clicks//////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////            

            
///////////////functions/////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////             
function Layout_Room(config,type) {
checkDirty(false);
    $myapp.find("button[data-name=reveal]").removeClass("btn-danger").addClass("btn-primary");
    $myapp.find("span.context").hide();
    showContext = false;
    $canvas.empty();

    var total_seats = config.width * config.height;
    var canvas_width = (seat_width + (2 * seat_margin)) * config.width;
    var canvas_height = (66 * config.height);
          for (var i = 0; i < total_seats; i++) {
              if (type === 'layout') {
                  $canvas.append("<div data-type=\"seat\" data-name=\""+(i+1)+"\"></div>"); 
              } else {
                  $canvas.append("<div data-type=\"space\" data-name=\""+(i+1)+"\"></div>");
              }
	      }
    if (type === 'layout') {
    	$myapp.find(".rmlayout.appactive table td:eq(1)").html(seats_img_bg+config.seats.length);
    }
    $.each(config.seats, function(key, value) {
        		$canvas.find("div[data-name="+value+"]").addClass("seat_selected");
    });
    $canvas.width(canvas_width);
    $canvas.height(canvas_height);
    $canvas.find("div").css({"width" : seat_width, "margin" : seat_margin});
}

function seatstudents() {
var activecontainer = 'L' + $('.stplan.appactive').data("name").slice(1);
var seatdata = $('.stplan.appactive').data("config").plan;
	seatdata.forEach(function(seatinfo) {
       var seat = seatinfo.split('-');
        $myapp.find("div[data-name="+seat[0]+"].seat_selected").html( $myapp.find("div[data-name="+activecontainer+"] .student [data-name="+seat[1]+"]").parent().html());
       $myapp.find("div[data-name="+activecontainer+"] .student [data-name="+seat[1]+"]").parent().hide();
    });
    checkAllSeated(activecontainer);
}                

function showContextualData(activeclass) {
    if ($myapp.find("div[data-name=L"+activeclass+"] .student:first").children(":first").data("context") !== undefined) {
    $myapp.find("span.context").remove();
	$myapp.find("div[data-name=L"+activeclass+"] .student").each(function(i,e) {
	var member_uuid = $(e).children(":first").data();
	//var html = "<br /><span class=\"context\">PP: "+capitaliseFirstLetter(member_uuid.context.pupil_premium)+" SEN: "+capitaliseFirstLetter(member_uuid.context.sen)+"</span>";
   // var html = "<br /><span class=\"context\">PP: "+capitaliseFirstLetter(member_uuid.context.pupil_premium||'')+" SEN: "+capitaliseFirstLetter(member_uuid.context.sen||'')+"</span>";
        var html = "<span class=\"context\"><br />";
        prefs[0].view.forEach(function(view) {
             if (view == "sen") {
                 html += "SEN: " + capitaliseFirstLetter(member_uuid.context.sen||'') + " ";    
             } else if (view == "eal") {
                 html += "EAL: " + capitaliseFirstLetter(member_uuid.context.eal||'') + " ";    
             } else if (view == "is_gifted") {
                 html += "IGT: " + capitaliseFirstLetter(member_uuid.context.is_gifted||'') + " ";    
             } else if (view == "pupil_premium") {
                 html += "PP: " + capitaliseFirstLetter(member_uuid.context.pupil_premium||'') + " ";    
             } else if (view == "fsm") {
                 html += "FSM: " + capitaliseFirstLetter(member_uuid.context.fsm||'') + " ";    
             } else if (view == "in_care") {
                 html += "LAC: " + capitaliseFirstLetter(member_uuid.context.in_care||'') + " ";    
             } 
        });
        html = html.slice(0, -1); 
        html += "</span>";
        
    $myapp.find("[data-name=L"+activeclass+"] .student table[data-name="+member_uuid.name+"] td:eq(0)").append(html);
	$myapp.find("[data-name=canvas] table[data-name="+member_uuid.name+"] td:eq(0)").append(html);
	});
    }
}
            
function checkAllSeated(activecontainer) {
    if ($myapp.find("div[data-name="+activecontainer+"] .student:visible").length === 0) {
        if ($myapp.find("div[data-name="+activecontainer+"] .seatedmsg").length === 0) {
            $myapp.find("div[data-name="+activecontainer+"]").append('<div class="seatedmsg">All students have been seated</div>');
        }
    } else {
        $myapp.find("div[data-name="+activecontainer+"] .seatedmsg").remove();
    }
}
             
function switch_layout(layout) {
    $myapp.find(".appactive").removeClass("appactive");
    $(layout).addClass("appactive");
     $myapp.find("div[data-name=groupPlan]").hide();
    $myapp.find("div[data-name=groupAuto]").hide();
     $myapp.find(".seatplanclasslist").hide();
    $myapp.find("div[data-name=groupLayout]").show();
    Layout_Room($(layout).data("config"),'layout');
}       
                     
var areYouSure = function(type, object) {
    var confirm_msg, confirm_title, confirm_function;
    if (type === 'deny_plan') {
        confirm_msg = "You can not make any seating plans until you have created at least one room layout<br />(you must also teach at least one class)";
        confirm_title = "There is a problem!";
        confirm_function = function() {};
    }
    if (type === 'save') {
        confirm_msg = "To discard your changes and contiune click 'confirm'<br />Otherwise click 'cancel' to go back and save your changes";
        confirm_title = "You have made changes without saving!";
        confirm_function = function() {
            if ($myapp.find(".appactive").attr('class').indexOf("stplan") > -1) {
                $myapp.find(".stplan.appactive tr:eq(0) td:eq(1)").html(seats_img+$myapp.find(".stplan.appactive").data("config").seats.length);
                $myapp.find(".stplan.appactive tr:eq(2) td:eq(1)").html(seated_img+$myapp.find(".stplan.appactive").data("config").plan.length);
                $myapp.find("div[data-name=L"+$myapp.find(".appactive").data("name").slice(1)+"]").hide();
                $myapp.find("div[data-name=groupPlan]").hide();
                $myapp.find("div[data-name=groupAuto]").hide();
            }
            if ($myapp.find(".appactive").attr('class').indexOf("rmlayout") > -1) {
                $myapp.find(".rmlayout.appactive table td:eq(1)").html(seats_img_bg+$myapp.find(".rmlayout.appactive").data("config").seats.length);
                $myapp.find("div[data-name=groupLayout]").hide();
            }
			$myapp.find(".appactive").removeClass("appactive");
            checkDirty(false);
            $canvas.empty();
            $(object).trigger("click");
        };
    }
   	if (type === 'delete') {
        if ($myapp.find(".appactive").attr('class').indexOf("rmlayout") > -1) {
        	confirm_msg = "Are your sure you want to delete this room layout?<br />Press 'confirm' to delete or 'cancel' to go back";
        } else {
            confirm_msg = "Are your sure you want to delete this seating plan?<br />Press 'confirm' to delete or 'cancel' to go back";
        }
        confirm_title = "Warning!";
        confirm_function = function() {
        	if ($myapp.find(".appactive").attr('class').indexOf("rmlayout") > -1) {
           		$myapp.find(".appactive").remove();
                $myapp.find("div[data-name=groupLayout]").hide();
            } else {
                $myapp.find(".appactive").parent().remove();
                $myapp.find("div[data-name=groupPlan]").hide();
                $myapp.find("div[data-name=groupAuto]").hide();
            }
          	$canvas.empty();
            checkDirty(false);
            gloabl_save();
        };
    }   
            this.confirm(confirm_msg, function(choice) {
                if (choice) {
                    confirm_function();
                }
            },
              {
                title: confirm_title,
                classes: "mymodal-blue",
                okClass: "btn-warning",
                ok: "Confirm"
            });
}.bind(this);        
                    
var loadclass = function (classid, containerid, startup) {
    Frog.Model.api('groups.getMembers',{ignore_profiles: true,uuid: classid})
        .done(function(thisResponse) {
        if (prefs[0].sorting == "surname") {
            thisResponse.data.sort(dynamicSort("surname"));
        }
        	$.each(thisResponse.data, function(i,member) {
            	if(member.profile.type === 'profile-student') {
                	var thumb = '';
                	//if (member.thumbnail.length) {
                    if (member.thumbnail && member.thumbnail.length) {
                    	thumb = file_path + member.thumbnail;
                        //thumb = file_path + default_image;
                	} else {
                    	//thumb = file_path + default_image;
                        thumb = default_image;
                	}
                    var sname;
                    if (prefs[0].sorting == "forename") {
                        sname = member.forename+"<BR>"+member.surname;
                    } else {
                        sname = member.surname+"<BR>"+member.forename;
                    }
            		$myapp.find("div[data-name="+containerid+"]").append("<div class=\"student\" data-gender=\""+member.gender+"\"><table data-name=\""+member.uuid+"\"><tr><td width=\"100%\">"+sname+"</td><td><div class=\"clip-circle\" style=\"background:url("+thumb+"?width=50&height=100\");\"></div></td></tr></table></div>");
                }
        	});
        $myapp.find("div[data-name=S"+containerid.slice(1)+"] tr:eq(1) td:eq(1)").html(student_img+$myapp.find("div[data-name="+containerid+"] .student").length);
        if (startup !== true) {
        doDragandDrop();
        seatstudents();
        }
    });
};
                   
function gloabl_save() {   
    var layouts = [];
	$myapp.find("div[data-name=rmlayout] .rmlayout").each(function(i,e){
   			layouts.push($(e).data("config"));
	});  
    var plans = [];      
	$myapp.find("div[data-name=plans] .stplan").each(function(i,e){
   			plans.push($(e).data("config"));
	});
var global_data = {layouts: layouts, plans: plans, prefs: prefs};
    
    Frog.Model.api('form.clearData', {
        uuid: form_uuid 
    },
    {
        type: 'POST'
    }).done(function(resp) {
        return Frog.Model.api('form.submission', {
            notify_creator: "0",
            site_uuid: site_uuid,
            uuid: form_uuid,
            fields: [{
                form_uuid: form_uuid,
                uuid: field_uuid,
                //value: JSON.stringify(global_data),
                value: JSON.stringify(global_data),
                type: 'field',
                label: 'global data'
            }]
        },
       {
            type: 'POST'
        }).done(function(resp) {

        }); 
    });  
}        
///////////////end of functions////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////// 
            
            
////////////drag and drop section//////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////               
function doDragandDrop() {
     if (/Mobi/.test(navigator.userAgent)) {
          $myapp.find(".student, .seat_selected").draggable({
            cursor: "move", revert: "invalid", opacity: 0.6, helper: "clone", appendTo: $canvas, stack: ".app-E45796BB200481BC87A61FAB6E9E6601F8D8ADBCA8073393 .ui-draggable"
        });
     } else {
        $myapp.find(".student, .seat_selected").draggable({
            cursor: "move", revert: "invalid", opacity: 0.6, helper: "clone", stack: ".app-E45796BB200481BC87A61FAB6E9E6601F8D8ADBCA8073393 .ui-draggable"
        });
     }
    $myapp.find(".seat_selected").droppable({
        greedy: true,
        hoverClass: "pos-over",
		 drop: function( event, ui ) {
         checkDirty(true);
         var draggable = ui.draggable, droppable = $(this);
           
             if (draggable.hasClass('student')) {
                 var activecontainer = $('.stplan.appactive:first').data("name").slice(1);
                 if (droppable.html().length > 0) {
                     var sid = droppable.children(":first").data("name");
                     $myapp.find("div[data-name=L"+activecontainer+"] .student [data-name="+sid+"]").parent().show();
                     } else {
                          var currentcount = parseInt($myapp.find("div[data-name=S"+activecontainer+"] tr:eq(2) td:eq(1)").text());
                         $myapp.find("div[data-name=S"+activecontainer+"] tr:eq(2) td:eq(1)").html(seated_img+(currentcount+1));
                                     if ($myapp.find("div[data-name=L"+activecontainer+"] .student:visible").length === 2) {
                                         if ($myapp.find("div[data-name=L"+activecontainer+"] .seatedmsg").length === 0) {
                                             $myapp.find("div[data-name=L"+activecontainer+"]").append('<div class="seatedmsg">All students have been seated</div>');
                                         }
                                     }
                     }
             		droppable.html( draggable.html() );
             		draggable.fadeOut();   
             } else {
                 var tmp = droppable.html();
                 droppable.html( draggable.html() );
                 draggable.html( tmp );
             }  
      	}
	});
}
////////////end of drag and drop section//////////////////////////////////
//////////////////////////////////////////////////////////////////////////
            
//////modal button functions////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////  
             this.element.off("click", "input"); 
             this.element.on("click", "input", function(e) {
                 e.stopPropagation();
             });
             
             this.element.off("keypress", ".modal input[type=text]:eq(0)"); 
             this.element.on("keypress", ".modal input[type=text]:eq(0)", function (e) {
                 if (e.which === 13) {
                     e.preventDefault();
                     return false;
                 }
             });   
             
             this.element.off("focus", ".modal input[type=text]:eq(0)"); 
             this.element.on("focus", ".modal input[type=text]:eq(0)", function (obj) {
                 var $searchbox = this.element.find(".group-search");
                 var $myclasses = $searchbox.find(".my-classes");
                 var $otherclasses = $searchbox.find(".other-classes");
                 var $searchbtn = $searchbox.find(".search-btn");
                 
                 if ($myclasses.find("li").length > 0) {
                     if ($(obj.target).val() == '') {
                         $searchbtn.removeClass("ff-search-mono").addClass("ff-cross-mono");
                         $myclasses.show();
                     }
                 }
             }.bind(this));
             
             this.element.off("blur", ".modal input[type=text]:eq(0)"); 
             this.element.on("blur", ".modal input[type=text]:eq(0)", function (obj) {
                  var $searchbox = this.element.find(".group-search");
                 var $myclasses = $searchbox.find(".my-classes");
                 var $otherclasses = $searchbox.find(".other-classes");
                 
                 setTimeout(function(){ 
                     $myclasses.hide();
                     $otherclasses.hide();
                 }, 300);
             }.bind(this));
             
             this.element.off("keyup", ".modal input[type=text]:eq(1)"); 
             this.element.on("keyup", ".modal input[type=text]:eq(1)", function () {
                 if (this.element.find(".modal input[type=text]:eq(1)").val() == "") {
                     this.element.find(".modal input[type=text]:eq(1)").css("border-color", "red");
                     this.element.find(".modal button[data-action=mymodal-plan-save]").prop('disabled', true);
                 } else {
                     this.element.find(".modal input[type=text]:eq(1)").css("border-color", "green");
                     checkButton();
                 }
             }.bind(this));
             
             
             this.element.off("keyup", ".modal input[type=text]:eq(0)"); 
             this.element.on("keyup", ".modal input[type=text]:eq(0)", function () {
                 var $searchbox = this.element.find(".group-search");
                 var $myclasses = $searchbox.find(".my-classes");
                 var $otherclasses = $searchbox.find(".other-classes");
                 var $searchbtn = $searchbox.find(".search-btn");

                 $searchbtn.removeClass("ff-search-mono").addClass("ff-cross-mono");
                 $searchbox.find('input').data("uuid","");
                 $searchbox.find('input').css("border-color", "red");
                 this.element.find(".modal button[data-action=mymodal-plan-save]").prop('disabled', true);
                 this.element.find(".modal input[type=text]:eq(1)").val("");
                 this.element.find(".modal input[type=text]:eq(1)").css("border-color", "red");
                 var s = $searchbox.find('input').val();
                 if ($myclasses.find("li").length > 0) {
                     if (s == '') {
                         $myclasses.show();
                     }
                 }
                 if(s.length > 1) {
                     delay(function(){
                         Frog.Model
                             .api(
                             'textsearch.search',
                             {
                                 profile: 'student',
                                 find: s,
                                 type: 'group',
                                 include_associations: true,
                                 exclude_sources: ['temporary']
                             } 
                         ).done(function(thisResponse) {
                             if (thisResponse.status.code === 0) {
                                 $otherclasses.empty();
                                 if (typeof thisResponse.data.group !== 'undefined') {
                                     var rgroups = thisResponse.data.group;
                                     $.each(rgroups, function(i,group) {
                                         if (group.type == "class") {
                                             $otherclasses.append('<li data-value="'+group.uuid+'"><a href="#"><span title="'+group.name+'"><i>Group: </i><strong>'+group.name+'</strong></span></a></li>');     
                                         }
                                     });
                                     $myclasses.hide();
                                     $otherclasses.show();
                                 } else {
                                     $otherclasses.hide();   
                                 } 
                             }
                         }); 
                     }, 600 );   
                 }
             }.bind(this));  
             

             var checkButton = function () {
                 if (this.element.find(".modal input[type=text]:eq(1)").val() != "" && this.element.find(".modal input[type=text]:eq(0)").val() != "") {
                     this.element.find(".modal button[data-action=mymodal-plan-save]").prop('disabled', false);
                 }
             }.bind(this);
             
             var delay = (function(){
                 var timer = 0;
                 return function(callback, ms){
                     clearTimeout (timer);
                     timer = setTimeout(callback, ms);
                 };
             }.bind(this))();   
             
             this.element.off("click", ".modal .search-btn");  
             this.element.on("click", ".modal .search-btn", function(e) {
                 var $searchbox = this.element.find(".group-search");
                 var $searchbtn = $searchbox.find(".search-btn");
                 $searchbox.find('input').val("");
                 $searchbox.find('input').data("uuid","");
                 $searchbtn.removeClass("ff-cross-mono").addClass("ff-search-mono");
                 $searchbox.find('input').css("border-color", "red");
                 this.element.find(".modal input[type=text]:eq(1)").val("");
                 this.element.find(".modal input[type=text]:eq(1)").css("border-color", "red");
                 this.element.find(".modal button[data-action=mymodal-plan-save]").prop('disabled', true);
             }.bind(this));
             
             this.element.off("click tap", ".modal .group-search li");  
             this.element.on("click tap", ".modal .group-search li", function(obj) {
                
                 var title = $(obj.target).closest("li").find("span").attr("title");
                 var uuid = $(obj.target).closest("li").data("value");
                 var $searchbox = this.element.find(".group-search");
                 var $myclasses = $searchbox.find(".my-classes");
                 var $otherclasses = $searchbox.find(".other-classes");
                 $searchbox.find('input').val(title);
                 $searchbox.find('input').data("uuid", uuid);
                 $searchbox.find('input').css("border-color", "green");
                 $myclasses.hide();
                 $otherclasses.hide();
                 
                 this.element.find(".modal input[type=text]:eq(1)").val(title+'-'+this.element.find(".modal select:eq(0) option:selected").text());
                 this.element.find(".modal input[type=text]:eq(1)").css("border-color", "green");
                 checkButton();
             }.bind(this));   

          
             
             
this.element.off("click", "[data-action=mymodal-cancel]");  
this.element.on("click", "[data-action=mymodal-cancel]", function () {
   this.hideModal(mymodal);
}.bind(this));     

this.element.off("click", "[data-action=mymodal-layout-save]");
this.element.on("click", "[data-action=mymodal-layout-save]", function () {
    var $input1 = this.element.find(".modal input[type=text]:first");
    var width = this.element.find(".modal select:eq(0)").val();
    var tall = this.element.find(".modal select:eq(1)").val();
    var seats =  this.element.find(".modal input[type=hidden]:first").val();
    var layout_guid = UUID.generate();
        if ($input1.val() === '') {
            $input1.parent().addClass('error');
        } else {
            $myapp.find(".appactive").removeClass("appactive");
            $myapp.find("div[data-name=groupPlan]").hide();
            $myapp.find("div[data-name=groupAuto]").hide();
     		$myapp.find(".seatplanclasslist").hide();
            $myapp.find("[data-name=rmlayout]").append("<div data-name=\""+layout_guid+"\" data-config=\'{\"guid\":\""+layout_guid+"\", \"name\":\""+encodeURIComponent($input1.val()).replace(/'/g, "%27")+"\",\"width\":"+width+",\"height\":"+tall+",\"seats\":["+seats+"]}\' class=\"rmlayout appactive\"><table><tr><td>CUSTOM LAYOUT<br />"+$input1.val()+"</td><td>"+seats_img_bg+"0</td></tr></table></div>");
            Layout_Room($myapp.find(".rmlayout.appactive").data("config"),'layout');
            $myapp.find("div[data-name=groupLayout]").show();
            gloabl_save();
            this.hideModal(mymodal);
        }
}.bind(this));   
                   
this.element.off("change", ".modal .savenewplan");  
this.element.on("change", ".modal .savenewplan", function () {
    this.element.find(".modal input[type=text]:eq(1)").val(this.element.find(".modal input[type=text]:eq(0)").val()+'-'+this.element.find(".modal select:eq(0) option:selected").text());
}.bind(this));              

this.element.off("click", "[data-action=mymodal-plan-save]");
this.element.on("click", "[data-action=mymodal-plan-save]", function () {
    var $input1 = this.element.find(".modal input[type=text]:eq(1)");
       // if ($input1.val() === '') {
        //    $input1.parent().addClass('error');
        //} else {
            	var layout_guid = this.element.find(".modal select:eq(0)").val();
            	var layoutconfig = $myapp.find("div[data-name="+layout_guid+"]").data("config");
            	var plan_guid = UUID.generate();
            	var plan_name = $input1.val().trim();
            //	var class_name = this.element.find(".modal select:eq(0) option:selected").text();
                var class_name = this.element.find(".modal input[type=text]:eq(0)").val();
            	var classid = this.element.find(".modal input[type=text]:eq(0)").data("uuid");
            	$myapp.find(".seatplanclasslist").hide();
            	$myapp.find("div[data-name=plans]").append("<div class=\"seatplandivider\"><div data-name=\"S"+plan_guid+"\" class=\"stplan\" data-config=\'{\"guid\":\""+plan_guid+"\", \"name\":\""+encodeURIComponent(plan_name).replace(/'/g, "%27")+"\",\"width\":"+layoutconfig.width+",\"height\":"+layoutconfig.height+",\"layout_guid\":\""+layoutconfig.guid+"\",\"layout_name\":\""+layoutconfig.name+"\",\"class_uuid\":\""+classid+"\",\"class_name\":\""+class_name+"\",\"seats\":["+layoutconfig.seats+"],\"plan\":[]}\'><table><tr><td width=\"125px\">Plan: "+plan_name+"</td><td>"+seats_img+layoutconfig.seats.length+"</td></tr><tr><td>Class: "+class_name+"</td><td>"+student_img+"</td></tr><tr><td>Layout: "+decodeURIComponent(layoutconfig.name).replace(/%27/g, '\'')+"</td><td>"+seated_img+"0</td></tr></table></div><div data-name=\"L"+plan_guid+"\" class=\"seatplanclasslist\"></div></div>");
            $myapp.find("div[data-name=S"+plan_guid+"]").trigger("click");
            gloabl_save();
            this.hideModal(mymodal);
       // }
}.bind(this));   
            

this.element.off("click", ".modal-body input[type=checkbox]");
this.element.on("click", ".modal-body input[type=checkbox]", function (event) {
    if (this.element.find(".modal-body input[type=checkbox]:checked").length < 5) {
        var tmparray = [];
        this.element.find(".modal-body input[type=checkbox]:checked").each(function(n, i){
            tmparray.push(i.id);
        });
        prefs[0].view = tmparray;
    } else {
        event.preventDefault();
        alert('You\'re not allowed to choose more than 4 boxes')
    }
}.bind(this));    
this.element.off("click", "[data-action=mymodal-pref-edit]");
this.element.on("click", "[data-action=mymodal-pref-edit]", function () {
    checkDirty(false);
    gloabl_save();
    if ( $myapp.find(".stplan.appactive").length > 0 ) {
   	 	var active_class = $myapp.find(".stplan.appactive").data("name").slice(1);
    	showContextualData(active_class);
	}
    this.hideModal(mymodal);      
}.bind(this));
             

this.element.off("change", "[data-action=mymodal-sorting]");
this.element.on("change", "[data-action=mymodal-sorting]", function () {
	prefs[0].sorting = this.element.find(".modal-body [data-action=mymodal-sorting]").val();    
}.bind(this));
             
             
this.element.off("click", "[data-action=mymodal-plan-edit]");
this.element.on("click", "[data-action=mymodal-plan-edit]", function () {
    var $input1 = this.element.find(".modal input[type=text]:first");
        if ($input1.val() === '') {
            $input1.parent().addClass('error');
        } else {
            	var plan_name = $input1.val().trim();
            	var ids = [];
            $('.seat_selected').each( function(i,e) {
                if ($(e).children().length !== 0) {
                    ids.push(""+$(e).data("name") + "-" + $(e).children(":first").data("name")+"");
                }
            });
            $myapp.find(".stplan.appactive tr:eq(0) td:eq(0)").html("Plan: "+plan_name);
            var myjson = $myapp.find(".stplan.appactive").data("config");
            $myapp.find(".stplan.appactive").data("config", { guid: myjson.guid, name: encodeURIComponent(plan_name).replace(/'/g, "%27"), width: myjson.width, height: myjson.height, layout_guid: myjson.layout_guid, layout_name: myjson.layout_name, class_uuid: myjson.class_uuid, class_name: myjson.class_name, seats: myjson.seats, plan: ids });
            checkDirty(false);
            gloabl_save();
            this.hideModal(mymodal);
        }
}.bind(this));               
//////end of modal button functions////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////////////       
            
            
////////////utility functions///////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////        
$(document).off('webkitfullscreenchange mozfullscreenchange fullscreenchange MSFullscreenChange');
$(document).on('webkitfullscreenchange mozfullscreenchange fullscreenchange MSFullscreenChange', function(e) {
    var state = document.fullScreen || document.mozFullScreen || document.webkitIsFullScreen || document.msFullscreenElement;
    var event = state ? 'FullscreenOn' : 'FullscreenOff';
    if (event === 'FullscreenOff') {
    		var newCss = { 'transform': 'scale(1)', 'transform-origin': 'top left'};
        	$myapp.find('div[data-name=canvas]').css(newCss);
            $myapp.find('div[data-name=myslider]').slider('value', 1);
    	}
});
  
function capitaliseFirstLetter(string) {
    return string.charAt(0).toUpperCase();
}

function dynamicSort(property) {
    var sortOrder = 1;
    if(property[0] === "-") {
        sortOrder = -1;
        property = property.substr(1);
    }
    return function (a,b) {
        var result = (a[property] < b[property]) ? -1 : (a[property] > b[property]) ? 1 : 0;
        return result * sortOrder;
    }
}             
             
function checkDirty(status) {
isdirty = status;
	if(status === true) {
		$myapp.find("[data-type=btn-save]").removeClass("btn-primary").addClass("btn-warning");
	} else {
		$myapp.find("[data-type=btn-save]").removeClass("btn-warning").addClass("btn-primary");
	}
}
            
var UUID = (function() {
  var self = {};
  var lut = []; for (var i=0; i<256; i++) { lut[i] = (i<16?'0':'')+(i).toString(16); }
  self.generate = function() {
    var d0 = Math.random()*0xffffffff|0;
    var d1 = Math.random()*0xffffffff|0;
    var d2 = Math.random()*0xffffffff|0;
    var d3 = Math.random()*0xffffffff|0;
    return lut[d0&0xff]+lut[d0>>8&0xff]+lut[d0>>16&0xff]+lut[d0>>24&0xff]+'-'+
      lut[d1&0xff]+lut[d1>>8&0xff]+'-'+lut[d1>>16&0x0f|0x40]+lut[d1>>24&0xff]+'-'+
      lut[d2&0x3f|0x80]+lut[d2>>8&0xff]+'-'+lut[d2>>16&0xff]+lut[d2>>24&0xff]+
      lut[d3&0xff]+lut[d3>>8&0xff]+lut[d3>>16&0xff]+lut[d3>>24&0xff];
  };
  return self;
})();         
///////////end if utility functions///////////////////////////////////////
//////////////////////////////////////////////////////////////////////////            
            
            
////////////other vars for use with modal//////////////////////////////////
//////////////////////////////////////////////////////////////////////////              
var new_plan = {
    title: "Save the details of your new seating plan",
   // body: "<table><tbody><tr><td style=\"width:100px\">Class:</td><td><select class=\"form-control savenewplan\"></select></td></tr><tr><td>Room layout:</td><td><select class=\"form-control savenewplan\"></select></td></tr><tr><td>Name:</td><td><div class=\"control-group\" width=\"100%\"><input type=\"text\" size=\"30\" class=\"form-control myinput\"></div></td></tr></tbody></table><br /><div class=\"pull-right\"><button class=\"btn btn-default\" data-action=\"mymodal-cancel\">Cancel</button>&#160;<button data-action=\"mymodal-plan-save\" class=\"btn btn-primary\">Save</button></div>",
    body: "<table><tbody><tr><td style=\"width:100px\">Class:</td><td><div class=\"group-search\"><input data-uuid=\"\" autocomplete=\"off\" type=\"text\" name=\"needle\" placeholder=\"Type the name of a group\"><ul class=\"other-classes typeahead dropdown-menu\" style=\"top: 30px; left: 0px; display: none;\"></ul><ul class=\"my-classes dropdown-menu\" style=\"display: none;\"></ul><button class=\"search-btn os-icon ff-search-mono\" name=\"button\" type=\"button\"></button></div></td></tr><tr><td>Room layout:</td><td><select class=\"form-control savenewplan\"></select></td></tr><tr><td>Name:</td><td><div class=\"control-group\" width=\"100%\"><input type=\"text\" size=\"30\" class=\"form-control myinput\"></div></td></tr></tbody></table><br /><div class=\"pull-right\"><button class=\"btn btn-default\" data-action=\"mymodal-cancel\">Cancel</button>&#160;<button data-action=\"mymodal-plan-save\" class=\"btn btn-primary\">Save</button></div>",
    customclass: "mymodal-blue",
    getInstance: function (caller) {
       return caller.modal(this.title,this.body,this.customclass, null, true);
    }  
};     
            
var edit_plan = {
    title: "Update the name of your seating plan",
    body: "<table><tbody><tr><td>Name:</td><td><div class=\"control-group\" width=\"100%\"><input type=\"text\" size=\"30\" class=\"form-control myinput\"></div></td></tr></tbody></table><br /><div class=\"pull-right\"><button class=\"btn btn-default\" data-action=\"mymodal-cancel\">Cancel</button>&#160;<button data-action=\"mymodal-plan-edit\" class=\"btn btn-primary\">Save</button></div>",
    customclass: "mymodal-blue",
    getInstance: function (caller) {
       return caller.modal(this.title,this.body,this.customclass, null, true);
    }  
};     
             
             var edit_prefs = {
                 title: "Preferences",
                 body: "<table><tbody><tr><td colspan=\"2\"><b>Contextual Data</b> (choose a maximum of 4)</td></tr><tr><tr><td colspan=\"2\">&nbsp;</td></tr><tr><td>SEN status (SEN)</td><td><input type=\"checkbox\" id=\"sen\" value=\"Y\"></td></tr><tr><td>Pupil Premium status (PP)</td><td><input type=\"checkbox\" id=\"pupil_premium\" value=\"Y\"></td></tr><tr><td>English Additional Language status (EAL)</td><td><input type=\"checkbox\" id=\"eal\" value=\"Y\"></td></tr><tr><td>Is Gifted status (IGT)</td><td><input type=\"checkbox\" id=\"is_gifted\" value=\"Y\"></td></tr><tr><td>Free School Meals status (FSM)</td><td><input type=\"checkbox\" id=\"fsm\" value=\"Y\"></td></tr><tr><td>Looked After/In Care status (LAC)</td><td><input type=\"checkbox\" id=\"in_care\" value=\"Y\"></td></tr><tr><td colspan=\"2\">&nbsp;</td></tr><tr><td colspan=\"2\"><b>Names of students</b> (requires app to be re-started)</td></tr><tr><tr><td colspan=\"2\">&nbsp;</td></tr><tr><td colspan=\"2\"><select data-action=\"mymodal-sorting\" class=\"form-control myselect-small\"><option value=\"forename\">Forename Surname</option><option value=\"surname\">Surname Forename</option></select></td></tr></tbody></table><br /><div class=\"pull-right\"><button class=\"btn btn-default\" data-action=\"mymodal-cancel\">Cancel</button>&#160;<button data-action=\"mymodal-pref-edit\" class=\"btn btn-primary\">Save</button></div>",
                 customclass: "mymodal-blue",
                 getInstance: function (caller) {
                     return caller.modal(this.title,this.body,this.customclass, null, true);
                 }  
             };     
            
var new_layout = {
    title: "Create a new room layout",
    body: "<div class=\"control-group\" width=\"100%\"><label class=\"control-label\">Enter a name for your new room layout in the box below</label><input type=\"text\" class=\"form-control myinput\"></div>Maximum desks wide (including any aisles) <select class=\"form-control myselect-small\"><option value=\"6\">6</option><option value=\"8\">8</option><option value=\"10\">10</option><option value=\"12\" selected>12</option><option value=\"14\">14</option></select><br/>Maximum desks tall (including any aisles) &#160;&#160;<select class=\"form-control myselect-small\"><option value=\"6\">6</option><option value=\"8\">8</option><option value=\"10\">10</option><option value=\"12\" selected>12</option><option value=\"14\">14</option></select><input type=\"hidden\"><br /><div class=\"pull-right\"><button class=\"btn btn-default\" data-action=\"mymodal-cancel\">Cancel</button>&#160;<button data-action=\"mymodal-layout-save\" class=\"btn btn-primary\">Save</button></div>",
    customclass: "mymodal-blue",
    getInstance: function (caller) {
       return caller.modal(this.title,this.body,this.customclass, null, true);
    }  
};
               
            
        }
    });
});