Com.Frog.Utils.require(
    '//package/widgets/25D2055C2001BED8375F8F0C47414003C71DF58C8B03ADCD/assets/styles/main.css',
    '//package/widgets/25D2055C2001BED8375F8F0C47414003C71DF58C8B03ADCD/assets/views/main.ejs',
    '//package/widgets/25D2055C2001BED8375F8F0C47414003C71DF58C8B03ADCD/widget.ejs'
).then(function() {
    Com.Frog.Controllers.Widget.extend('Widget.PopUpMessage', {
    }, {
        prefs: {
            msgHeader: {
                type: 'text',
                defaultValue: '',
                label: 'Title',
                placeholder: 'My message'
            },
            modalText: {
                type: 'textarea',
                defaultValue: 'Does this Work!',
                label: 'Message',
                placeholder: 'Hello world'
            },
            image: {
                type: 'upload',
                label: 'Image to display',
                showDiscover: false,
                showClipboard: false,
                filter: ['image'],
                view: 'mini',
                sources: ['native'],
                accordion: 'Media',
                defaultValue: ''
            },
            media: {
                type: 'textarea',
                label: 'Media embed code',
                defaultValue: '',
                accordion: 'Media'
            },
            linkTitle: {
                type: 'text',
                label: 'Link button text',
                defaultValue: 'Click here',
                accordion: 'Link'
            },
            link: {
                type: 'text',
                label: 'Link',
                defaultValue: '',
                accordion: 'Link'
            },
            fontSize: {
                type: 'number',
                label: 'Text size',
                defaultValue: 14,
                showUnits: 'px',
                accordion: 'Design'
            },
            bgColour: {
                type: 'colourpicker',
                label: 'Background colour',
                defaultValue: '#FFFFFF',
                accordion: 'Design'
            },
            textColour: {
                type: 'colourpicker',
                label: 'Text colour',
                defaultValue: '#000000',
                accordion: 'Design'
            }
        },

        packageID: '25D2055C2001BED8375F8F0C47414003C71DF58C8B03ADCD',

        init: function() {},

        'widget.live': function(el, ev, data) {
            this.element.html(
                this.view('main.ejs')
            );
            this.renderMessage('modal');
        },
        
        renderMessage : function(view) {
            var msgHeader = 'Message';
            
            if (this.prefs.msgHeader.value !== '') {
                msgHeader = this.prefs.msgHeader.value;
            }

            if (view == 'modal') {
                var modal = this.modal(msgHeader, this.view('modal.ejs'));
                this.addStyling(modal);
            } else {
                this.element.find('h3').append(msgHeader);
                this.element.find('.modalMessage').html(this.view('modal.ejs'));
                this.addStyling(this.element.find('.widget_popout_message_modal'));
            }

        },
        
        addStyling : function(modalOrPreview) {
            var lineHeight = parseInt(this.prefs.fontSize.value,10)+5;
            
            modalOrPreview.css('font-size', this.prefs.fontSize.value+'px');
            modalOrPreview.css('line-height', lineHeight+'px');
            modalOrPreview.css('background', this.prefs.bgColour.value);
            modalOrPreview.css('color', this.prefs.textColour.value);
        },
        
        'widget.edit': function(el, ev, data) {
            this.element.html(
                this.view('./widget.ejs')
            );
            this.renderMessage('edit');
        },
        'widget.save': function(el, ev, data) {
            this.element.html(
                this.view('./widget.ejs')
            );
            this.renderMessage('edit');
        },

        'widget.updated': function(el, ev, data) {}
    });
});
