Com.Frog.Utils.require(
    '//package/widgets/74E1CCD52001BB92A8F99F78D248D309E129B86CB64A246C/assets/styles/main.css',
    '//package/widgets/74E1CCD52001BB92A8F99F78D248D309E129B86CB64A246C/assets/views/main.ejs',
    '//package/widgets/74E1CCD52001BB92A8F99F78D248D309E129B86CB64A246C/widget.ejs'
).then(function() {
    Com.Frog.Controllers.Widget.extend('Widget.PictureSeries', {
    }, {
        prefs: {
            picture_grid : {
                type: "list",
                label: "How many picture links?",
                defaultValue: "4",
                options : {
                    "4" : "4",
                    "6" : "6"
                },
                accordion: 'Picture'
            },
            picture_fit : {
                type: "list",
                label: "Picture fit",
                defaultValue: "cover",
                options : {
                    "Cover" : "cover",
                    "Contain" : "contain",
                    "Fill" : "fill",
                    "Scale down" : "scale_down"
                },
                accordion: 'Picture'
            },
            picture_effect : {
                type: "list",
                label: "Picture effect",
                defaultValue: "none",
                options : {
                    "None" : "none",
                    "Grow" : "grow"
                },
                accordion: 'Picture'
            },
            picture_bp_triples: {
                type: 'text',
                label: "Set screen width to break to triples (x6 grid only)",
                defaultValue: "1200px",
                accordion: 'Picture'
            },
            picture_bp_doubles: {
                type: 'text',
                label: "Set screen width to break to doubles",
                defaultValue: "800px",
                accordion: 'Picture'
            },
            picture_bp_singles: {
                type: 'text',
                label: "Set screen width to break to singles",
                defaultValue: "400px",
                accordion: 'Picture'
            },
            caption_visibility : {
                type: "list",
                label: "Show/Hide Caption?",
                defaultValue: "show",
                options : {
                    "Show" : "show",
                    "Hide" : "hide"
                },
                accordion: 'Caption'
            },
            caption_fontcolour: {
                type: 'colourpicker',
                label: 'Choose caption font colour',
                defaultValue: '#FFFFFF',
                accordion: 'Caption'
            },
            caption_fontsize: {
                type: 'text',
                label: "Alter font size relative to site default (typical values: 0.5-1.5, 1=same)",
                defaultValue: "1.0",
                accordion: 'Caption'
            },
            caption_colour: {
                type: 'colourpicker',
                label: 'Choose caption background colour',
                defaultValue: '#002070',
                accordion: 'Caption'
            },
            caption_opacity: {
                type: 'text',
                label: "Set caption background opacity (0-1)",
                defaultValue: "0.4",
                accordion: 'Caption'
            },
            border_style : {
                type: "list",
                label: "Border style",
                defaultValue: "none",
                options : {
                    "None" : "none",
                    "Solid" : "solid",
                    "Dashed" : "dashed",
                    "Dotted" : "dotted",
                    "Double" : "double"
                },
                accordion: 'Border'
            },
            border_thickness : {
                type: 'text',
                label: "Set border thickness (0-50)",
                defaultValue: "1",
                accordion: 'Border'
            },
            border_colour: {
                type: 'colourpicker',
                label: 'Choose border colour',
                defaultValue: '#000000',
                accordion: 'Border'
            },
            border_corners: {
                type: 'text',
                label: "Rounded corners (TL TR BR BL)",
                placeholder: "TL TR BR BL",
                defaultValue: "0px 0px 0px 0px",
                accordion: 'Border'
            },
            data_store: {
                type: 'hidden',
                label: "This is hidden",
                defaultValue: "{}"
            }
        },

        myuuid: '',
        
        data_store: {},

        packageID: '74E1CCD52001BB92A8F99F78D248D309E129B86CB64A246C',

        init: function() {
            this.myuuid = this.generateUuid();
            this.data_store = JSON.parse(this.prefs.data_store.value);
        },

        LiveUpdate: function() {
            var baseURL = Frog.Utilities.getBaseUrl();
            var default_picture = baseURL + "/app/file/resource/7D1FC6C9200306F56E36FFDD0BAC7609F4B3C33C6D461245?1552842298.jpg";
			var default_caption_text = "Caption text";
            
            if (this.isEmptyArray(this.data_store)) {
                this.data_store.pic1 = {url: default_picture, caption: default_caption_text, link: "", linktype: "E"};
                this.data_store.pic2 = {url: default_picture, caption: default_caption_text, link: "", linktype: "E"};
                this.data_store.pic3 = {url: default_picture, caption: default_caption_text, link: "", linktype: "E"};
                this.data_store.pic4 = {url: default_picture, caption: default_caption_text, link: "", linktype: "E"};
                this.data_store.pic5 = {url: default_picture, caption: default_caption_text, link: "", linktype: "E"};
                this.data_store.pic6 = {url: default_picture, caption: default_caption_text, link: "", linktype: "E"};
            }
           
            if (this.prefs.picture_grid.value == "4") {
                this.element.html(
                    this.view('main.ejs', {
                        data: JSON.stringify(this.data_store),
                        unique: this.myuuid,
                        bpSngles: this.prefs.picture_bp_singles.value,
                        bpDoubles: this.prefs.picture_bp_doubles.value
                    })
                );
            } else {
                this.element.html(
                    this.view('main6.ejs', {
						data: JSON.stringify(this.data_store),
                        unique: this.myuuid,
                        bpSngles: this.prefs.picture_bp_singles.value,
                        bpDoubles: this.prefs.picture_bp_doubles.value,
                        bpTriples: this.prefs.picture_bp_triples.value
                    })
                );
            }
            
            this.element.find(".pic-links").css("border-style",this.prefs.border_style.value);
            this.element.find(".pic-links").css("border-width",this.prefs.border_thickness.value+"px");
            this.element.find(".pic-links").css("border-color",this.prefs.border_colour.value);
            this.element.find(".pic-links").css("border-radius",this.prefs.border_corners.value);
            this.element.find(".pic-links img").css("object-fit",this.prefs.picture_fit.value);
            this.element.find(".pic-links .caption").css("background-color",this.hexToRGB(this.prefs.caption_colour.value, this.prefs.caption_opacity.value));
            this.element.find(".pic-links .caption").css("color",this.prefs.caption_fontcolour.value);
            this.element.find(".pic-links .caption").css("font-size",this.prefs.caption_fontsize.value+"em");

            if (this.prefs.caption_visibility.value == "hide") {
                this.element.find(".caption").hide();    
            } else {
                this.element.find(".caption").show();
            }
            
            if (this.prefs.picture_effect.value == "grow") {
                this.element.find(".pic-links-child").addClass("pic-link-grow");
            } else {
                this.element.find(".pic-links-child").removeClass("pic-link-grow");
            }
        },
        
        '.edit-wrapper click': function(el, ev) {
            if (this.state != "edit") {
                var pic = $(ev.currentTarget).closest('div.edit-wrapper').data("id");
                var link_url = this.data_store[pic].link;
                if (link_url != '') {
                    if (this.data_store[pic].linktype == "E") {
                        link_url = (link_url.indexOf('://') === -1) ? 'http://' + link_url : link_url;
                        window.open(link_url);
                    } else {
                        var $menu = this.element.closest('.sites_core').find('.sites_menu');
                        $menu.trigger('sites.changeLocation', {
                            uuid: link_url
                        });
                    }
                }
            }
        },
        
        '[data-action="pic-upload"] click': function(el, ev) {
            var pic = $(ev.currentTarget).closest('div.edit-wrapper').data("id");
            $('.os_core:first').trigger('os.app.upload', {
                "data": {
                    "upload_type": "asset",
                    "site_uuid":  this.options.site_uuid,
                    "focusApp": this.element.closest('div.app_dialog'),
                    "callback": function(result) {
                        if (result.files && result.files.length) {
                                if (this.allowedFileType(result.files[0].attachment.file.mime.ext)) {
                                    this.data_store[pic].url = result.files[0].external_url;
                                    this.element.find("[data-id="+pic+"] img:first").attr("src",result.files[0].external_url);
                                    this.prefs.data_store.value = JSON.stringify(this.data_store);
                                }
                        }
                    }.bind(this)
                }
            });  
        },
        
        '[data-action="pic-update"] click': function(el, ev) {
            var pic = $(ev.currentTarget).closest('div.edit-wrapper').data("id");
            var mymodal = this.modal("Update the picture: "+pic,"<div class=\"control-group\" width=\"100%\">Caption: <input type=\"text\" data-name=\"mymodal-caption\" class=\"form-control myinput\"></div><div class=\"control-group\" width=\"100%\">Link:&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <select data-name=\"mymodal-linktype\" class=\"form-control myselect-small\"><option value=\"E\">External</option><option value=\"I\">Internal</option></select></div><div data-name=\"internal\" class=\"control-group\" width=\"100%\">Page:&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <select data-name=\"mymodal-page\" class=\"form-control myselect-small\"></select></div><div data-name=\"external\" class=\"control-group\" width=\"100%\">URL:&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <input type=\"text\" data-name=\"mymodal-link\" class=\"form-control myinput\"></div><div class=\"pull-right\"><button class=\"btn btn-default\" data-action=\"mymodal-cancel\">Cancel</button>&#160;<button data-action=\"mymodal-save\" class=\"btn btn-primary\">Save</button></div>","mymodal-blue", null, true);
            
            $(".modal input[data-name=mymodal-caption]").val(this.data_store[pic].caption);
            $(".modal select[data-name=mymodal-linktype]").val(this.data_store[pic].linktype);

            if (this.data_store[pic].linktype == "E") {
                $(".modal input[data-name=mymodal-link]").val(this.data_store[pic].link);
                $(".modal div[data-name=internal]").hide();
                $(".modal div[data-name=external]").show();
            } else { 
                $(".modal div[data-name=internal]").show();
                $(".modal div[data-name=external]").hide();
            }    
            
            Frog.Model.api('pages.getNavigation', { 
                site: this.options.siteLink
            }).done(function(res) {
                $.each(res.data.children, function(k1, d1) {
                    $(".modal select[data-name=mymodal-page]").append("<option value='"+d1.node.uuid+"'>"+d1.node.name+"</option>");
                    if (d1.hasOwnProperty("children")) {
                        $.each(d1.children, function(k2, d2) {
                            $(".modal select[data-name=mymodal-page]").append("<option value='"+d2.node.uuid+"'>"+d1.node.name + " / " + d2.node.name+"</option>");
                            if (d2.hasOwnProperty("children")) {
                                $.each(d2.children, function(k3, d3) {
                                    $(".modal select[data-name=mymodal-page]").append("<option value='"+d3.node.uuid+"'>"+d1.node.name + " / " + d2.node.name + " / " + d3.node.name+"</option>");
                                });
                            }
                        });
                    }
                });
                $(".modal select[data-name=mymodal-page]").val(this.data_store[pic].link);
            }.bind(this))
            
            $(document.body).off("change", "[data-name=mymodal-linktype]"); 
            $(document.body).on("change", "[data-name=mymodal-linktype]", function () {
                if ($(this).val() == "E") {
                    $(".modal div[data-name=internal]").hide();
                    $(".modal div[data-name=external]").show();
                } else {
                    $(".modal div[data-name=internal]").show();
                    $(".modal div[data-name=external]").hide();
                }
            });
            
            $(document.body).off("click", "[data-action=mymodal-cancel]"); 
            $(document.body).on("click", "[data-action=mymodal-cancel]", function () {
                this.hideModal(mymodal);
            }.bind(this));
            
            $(document.body).off("click", "[data-action=mymodal-save]"); 
            $(document.body).on("click", "[data-action=mymodal-save]", function () {
                this.data_store[pic].caption = $(".modal input[data-name=mymodal-caption]").val();
                this.data_store[pic].linktype = $(".modal select[data-name=mymodal-linktype]").val();
                if (this.data_store[pic].linktype == "E") {
                    this.data_store[pic].link = $(".modal input[data-name=mymodal-link]").val();
                } else {
                    this.data_store[pic].link = $(".modal select[data-name=mymodal-page]").val();
                }
                this.element.find("[data-id="+pic+"] .caption").html(this.data_store[pic].caption);
                this.prefs.data_store.value = JSON.stringify(this.data_store);
                this.hideModal(mymodal);
            }.bind(this)); 
        },
        
        allowedFileType: function(type) {
            if(type.toLowerCase() == "gif" || type.toLowerCase() == "jpeg" || type.toLowerCase() == "jpg" || type.toLowerCase() == "png") {
				return true;
            } else {
				return false;
            }  
        },
        
        hexToRGB: function (hex, alpha) {
            var r = parseInt(hex.slice(1, 3), 16),
                g = parseInt(hex.slice(3, 5), 16),
                b = parseInt(hex.slice(5, 7), 16);
            if (alpha) {
                return "rgba(" + r + ", " + g + ", " + b + ", " + alpha + ")";
            } else {
                return "rgb(" + r + ", " + g + ", " + b + ")";
            }
        },

        generateUuid: function() {
            return 'xxxxxxxx-xxxxxx'.replace(/[xy]/g, function(c) {
                var r = Math.random() * 16 | 0, v = c == 'x' ? r : (r & 0x3 | 0x8);
                return v.toString(16);
            });
        },
        
        isEmptyArray: function (obj) {
            for(var key in obj) {
                if(obj.hasOwnProperty(key))
                    return false;
            }
            return true;
        },
        
        'widget.live': function(el, ev, data) {
            this.LiveUpdate();
        },

        'widget.edit': function(el, ev, data) {
            this.LiveUpdate();
        },

        'widget.updated': function(el, ev, data) {
            this.LiveUpdate();
        },

        'widget.save': function(el, ev, data) {
            this.LiveUpdate();
        }

    });
});
