Com.Frog.Utils.require(
    '//package/widgets/B35B0FAE2001BA4583358F788054010052AAAE3C7C7E8B8C/assets/styles/main.css',
    '//package/widgets/B35B0FAE2001BA4583358F788054010052AAAE3C7C7E8B8C/assets/views/main.ejs',
    '//package/widgets/B35B0FAE2001BA4583358F788054010052AAAE3C7C7E8B8C/widget.ejs'
).then(function() {
    Com.Frog.Controllers.Widget.extend('Widget.PaperCutMyPrinting', {
    }, {
        prefs: {
            papercut: {
                type: "text",
                label: "Enter server name for PaperCut",
                defaultValue: "printserver"
            },
            port: {
                type: "text",
                label: "Enter port for PaperCut server",
                defaultValue: "9192"
            }
        },

        packageID: 'B35B0FAE2001BA4583358F788054010052AAAE3C7C7E8B8C',
        /**
         * Constructor. Runs when the widget is first loaded.
         *
         * @method init
         */
        init: function() {},

        /**
         * Event fired by the Site Controller.
         *
         * @event 'widget.live'
         */
        'widget.live': function(el, ev, data) {
            this.element.html(
                this.view('main.ejs')
            );
            
            
            var currentuser = FrogOS.getUser().username;
            var server = this.prefs.papercut.value;
            var port = this.prefs.port.value;
            var widget = this;
            var widget_uuid = widget.options.uuid;
            var data_store_uuid = '';
            var data_store = {};
            
            function AddToDataStore() {
                if (data_store_uuid == '') {
                    //do save
                    FrogOS.fdp({
                        url: 'datastore/create',
                        path: '/api/fdp/2/',
                        type: 'POST',
                        data: {
                            target_uuid: widget_uuid,
                            data: JSON.stringify(data_store),
                            alias: 'PaperCut Printing Impact',
                            user_uuid: FrogOS.getUser().uuid
                        }
                    }).done(function(response) {
                        data_store_uuid = response.response.uuid;
                        console.log("done create");
                    }).fail(function(e) {
                        console.log("failed create");
                    });
                } else {
                    //do update
                    console.log("store id is: " + data_store_uuid);
                    FrogOS.fdp({
                        url: 'datastore/update',
                        path: '/api/fdp/2/',
                        type: 'POST',
                        data: {
                            uuid: data_store_uuid,
                            data: JSON.stringify(data_store)
                        }
                    }).done(function(response) {
                        console.log("Updated!");
                        console.log("done update");
                    }).fail(function(e) {
                        console.log("failed update");
                    });
                }
            }
            
            
            function GetDataStore() {
                widget.showLoader(
                    widget.element.find(".pcuei"),
                    'dark',
                    'Please wait...'
                );
                FrogOS.fdp({
                    url: 'datastore/get',
                    path: '/api/fdp/2/',
                    type: 'GET',
                    data: {
                        target_uuid: widget_uuid,
                    }
                }).done(function(response) {
                    if (typeof(response.response[0]) != 'undefined') {
                        data_store_uuid = response.response[0].uuid;
                        data_store = JSON.parse(response.response[0].data);
                    }
                    console.log("done get");
                    var timeoutId;
                    timeoutId = window.setTimeout(function() {
                        console.log("Error");
                        //output from cache
                        if (!$.isEmptyObject(data_store)) {
                            widget.find("[data-id='pages']").html(data_store.printStats.pages + " pages");
                            widget.find("[data-id='trees']").html(data_store.environmentalImpact.treesFormatted);
                            widget.find("[data-id='co2']").html(data_store.environmentalImpact.gramsCO2Formatted + " of CO<sub>2</sub>");
                            widget.find("[data-id='power']").html(data_store.environmentalImpact.bulbHoursFormatted);
                            widget.find("[data-id='since']").html(data_store.printStats.sinceDateFormatted); 
                        }
                        widget.hideLoader();
                    }, 5000);
                    $.getScript("https://"+server+":"+port+"/rpc/api/web/user/"+currentuser+"/details.js", function(){
                        window.clearTimeout(timeoutId);
                        if (!$.isEmptyObject(pcUserDetails)) {
                            widget.find("[data-id='pages']").html(pcUserDetails.printStats.pages + " pages");
                            widget.find("[data-id='trees']").html(pcUserDetails.environmentalImpact.treesFormatted);
                            widget.find("[data-id='co2']").html(pcUserDetails.environmentalImpact.gramsCO2Formatted + " of CO<sub>2</sub>");
                            widget.find("[data-id='power']").html(pcUserDetails.environmentalImpact.bulbHoursFormatted);
                            widget.find("[data-id='since']").html(pcUserDetails.printStats.sinceDateFormatted); 
                            
                            data_store = pcUserDetails;
                            AddToDataStore();
                            widget.hideLoader();
                        }
                    });
					
                }).fail(function(e) {
                    console.log("failed to get datastore");
                });
            }
            
            GetDataStore();

        },

        /**
         * Event fired by the Site Controller. Tells the widget that the site is in Edit Mode.
         *
         * @event 'widget.edit'
         */
        'widget.edit': function(el, ev, data) {
            this.element.html(
                this.view('./widget.ejs')
            );
        },

        /**
         * Event fired by the Site Controller. Tells the widget that something has been changed during editing.
         *
         * @event 'widget.updated'
         */
        'widget.updated': function(el, ev, data) {}
    });
});
