Com.Frog.Utils.require(
    '//package/widgets/E902240B2001B43D8F487F2C9F410C0F8E09D20C1EF57705/assets/styles/main.css',
    '//package/widgets/E902240B2001B43D8F487F2C9F410C0F8E09D20C1EF57705/assets/views/main.ejs',
    '//package/widgets/E902240B2001B43D8F487F2C9F410C0F8E09D20C1EF57705/assets/views/placeholder.ejs',
    '//package/widgets/E902240B2001B43D8F487F2C9F410C0F8E09D20C1EF57705/widget.ejs'
).then(function() {
    Com.Frog.Controllers.Widget.extend('Widget.Office365DocEmbed', {
    }, {
        prefs: {
            "doclink":{
                "type":"text",
                "label":"Shared Doc link, make sure your sharing settings are correct in OneDrive",
                "defaultValue":""
            },
            "height": {
                "type":"number",
                "label":"Height",
                "defaultValue":400
            }
        },

        packageID: 'E902240B2001B43D8F487F2C9F410C0F8E09D20C1EF57705',
        /**
         * Constructor. Runs when the widget is first loaded.
         *
         * @method init
         */
        init: function() {},

        /**
         * Event fired by the Site Controller.
         *
         * @event 'widget.live'
         */
        'widget.live': function(el, ev, data) {
            if (this.prefs.doclink.value === "") {
                 this.renderPlaceholder();
            } else {
                var docsrc = this.prefs.doclink.value.split('&action=edit'),
                    sharelink = docsrc[0].replace("guestaccess", "WopiFrame");

                 this.element.html(
                    this.view('main.ejs')
                );
                this.element.find('.embedder').attr('src', sharelink+'&action=embedview&wdAr=1.3333333333333333');
            }
        },

        /**
         * Event fired by the Site Controller. Tells the widget that the site is in Edit Mode.
         *
         * @event 'widget.edit'
         */
        'widget.edit': function(el, ev, data) {
            this.renderPlaceholder();
        },
        'widget.save': function(el, ev, data) {
            this.renderPlaceholder();
        },
        renderPlaceholder : function() {
            this.element.html(
                this.view('placeholder.ejs')
            );
            this.element.find('.placeholder').css("height", this.prefs.height.value + "px");
            this.element.find('.placeholder').css("line-height", this.prefs.height.value + "px");
        }
    });
});
