Com.Frog.Utils.require(
    '//package/widgets/A5462C162001B23860F81F5894ECEC0E32510CBC0EB3ABD3/assets/styles/main.css',
    '//package/widgets/A5462C162001B23860F81F5894ECEC0E32510CBC0EB3ABD3/assets/views/main.ejs',
    '//package/widgets/A5462C162001B23860F81F5894ECEC0E32510CBC0EB3ABD3/assets/views/item.ejs',
    '//package/widgets/A5462C162001B23860F81F5894ECEC0E32510CBC0EB3ABD3/assets/views/del.ejs',
    '//package/widgets/A5462C162001B23860F81F5894ECEC0E32510CBC0EB3ABD3/assets/models/models.js',
    '//package/widgets/A5462C162001B23860F81F5894ECEC0E32510CBC0EB3ABD3/assets/models/eportfolios_models.js',
    '//package/widgets/A5462C162001B23860F81F5894ECEC0E32510CBC0EB3ABD3/widget.ejs'
).then(function() {
    Com.Frog.Controllers.Widget.extend('Widget.MyNotifications', {
    }, {
        prefs: {
            assDue: {
	           type: "boolean",
	           label: "Assignment Due (appears from the day before)",
	           defaultValue: false
           },
            assIssue: {
	           type: "boolean",
	           label: "Assignment issued",
	           defaultValue: false
           },
            assMarks: {
	           type: "boolean",
	           label: "Assignment Marks Released",
	           defaultValue: true
           },
            assMessage: {
	           type: "boolean",
	           label: "Assignment Wall Message",
	           defaultValue: true
           },
           feedback: {
	           type: "boolean",
	           label: "Feedback comments made",
	           defaultValue: true
           },
           inbox: {
	           type: "boolean",
	           label: "Message sent (check your inbox)",
	           defaultValue: true
           },
           share: {
	           type: "boolean",
	           label: "A site has been shared",
	           defaultValue: true
           },
           notice: {
	           type: "boolean",
	           label: "A notice has been added",
	           defaultValue: true
           },
           forum: {
	           type: "boolean",
	           label: "There is a new post on a forum",
	           defaultValue: true
           },
           custom: {
	           type: "boolean",
	           label: "Provide a custom message using the FDP API",
	           defaultValue: true,
               accordion: 'Custom message'
           },
           customText: {
               type: 'text',
               label: 'Message',
               defaultValue: 'Your ePortfolio has been updated',
               accordion: 'Custom message'
           },
           height: {
               type: 'number',
               label: 'Height',
               defaultValue: 400,
               accordion: 'Design'
           },
           title: {
               type: 'text',
               label: 'Widget Title',
               defaultValue: 'Your notifications',
               accordion: 'Design'
           }
        },
        edit_mode : 'edit',
        packageID: 'A5462C162001B23860F81F5894ECEC0E32510CBC0EB3ABD3',

        init: function() {
            this.edit_mode = 'live';
        },

        'widget.live': function(el, ev, data) {
            this.edit_mode='live';
            this.render();
        },       
        
        render: function(mode) {
            var self = this;
            self.element.html(
                self.view('main.ejs')
            );
            var notesTable = self.element.find('.notes_table');
            
            if (self.edit_mode == 'live') {

                Frog.Model.api('alerts.getAlerts').done(function(response) {
                    var notes = response.data;

                    $.each(notes, function(index,note) {
                        notesTable.append(
                            self.view('item.ejs', {note: note})
                        )
                    });

                    var delOptions = self.element.find('.del_options');
                    delOptions.append(
                            self.view('del.ejs')
                    )
                }).fail(function(e) {
                    // Report Error
                    console.log("failed");
                });
                setTimeout(function(){ self.render() }, 3600000);    
            } else { // end of live mode
                /* Dummy notifications to display when editing */
                var dummyNotes = {
                    'feedback':{action_code: 'feedback.teacher.activity',  message_params: [{value:'X'},{value:'Example'}, {value:'Example'}], app_params: {assignment: ''}},
                    'sites':{action_code: 'share.target', message_params: [{value:'X'},{value:'X'},{value:'Example site'}], app_params: {link: '-'}},
                    'assignment':{action_code: 'assignment.message', message_params: [{value:'Assignment name'},{value:'message text'}], app_params: {assignment: ''}}
                };
                $.each(dummyNotes, function(index,dummyNote) {
                    notesTable.append(
                        self.view('item.ejs', {note: dummyNote})
                    )
                });
            }
            notesTable.css('height',self.prefs.height.value+'px');         
        },
        
        '.item {click}': function(ev) {
            var clickType = ev.data().type,
                self = this;

            if (clickType == 'generic') {
                var order = {},
                    method = 'getMyEportfolios';

                order[self.options.sortKey] = self.options.sortDirection;
                Widget.Models.Eportfolio[method]({
                    'order': order
                }).done(function(sites) {
                    if (sites.length) { // get first eportfolio
                        self.element.trigger('os.app.siteviewer', {
                            data: { site: sites[0].link }
                        });
                        Frog.Model.api('alerts.expireAlerts', {
                            type: 'generic',
                            before: moment().unix()
                        },{type: "POST"}).done( function() {
                            self.render();        
                        })
                    } 
                });
            
            } else if (clickType == 'assignment' || clickType == "share") {
                self.element.trigger('os.app.siteviewer', {
                    data: { site: ev.data().assid }
                });
                
            } else if (clickType == 'inbox') { // activate the message inbox in the frogbar
                setTimeout(function(){ $('.inbox-icon__content').trigger('click');}, 100);
                    Frog.Model.api('alerts.expireAlerts', {
                        type: 'message',
                        before: moment().unix()
                    },{type: "POST"}).done( function() {
                        self.render();     
                    })    
                
            } else if (clickType == 'feedback' || clickType == 'assignment_message') { // feedback and assignment messages alerts do not contain site alias, only UUIDs
                if (self.accessCheck() == 'assignment') { // Open the assignment site if a student
                    Frog.Model.api('sites.getByUuid', {
                        uuid: ev.data().assid
                    }).done(function(response) {
                        self.element.trigger('os.app.siteviewer', {
                            data: { site: response.data.link }
                        });
                    });
                } else { // open the markbook if a teacher
                    self.element.trigger('os.internal.launchapp', {
                        data: {
                            name: 'markbookmanager',
                            view: 'markbook',
                            assignment_deeplink_uuid: ev.data().assid
                        }
                    });
                }
            }
        },
        
        '.del {click}': function(ev) {
            var self = this,
                clickType = ev.data().type;

            Frog.Model.api('alerts.expireAlerts', {
                type: clickType,
                before: moment().unix()
            },{type: "POST"}).done( function() {
                self.render();                   
            });
        },
        
        accessCheck: function() {
            var user = FrogOS.getUser();
            if (user.profile.name === "Admin" || user.profile.name === "Staff") {
                return "markbook";
            } else {
                return "assignment";
            }
        },

        'widget.edit': function(el, ev, data) {
            this.edit_mode='edit';
            this.render();    
        },
        'widget.save': function(el, ev, data) {
            this.edit_mode='edit';
            this.render();      
        },

        'widget.updated': function(el, ev, data) {}
    });
});
