Com.Frog.Utils.require(
    '//package/widgets/721F3B9B2001B256AAC6DF98655DAF0D0CFF4ABCC577BCC4/assets/styles/main.css',
    '//package/widgets/721F3B9B2001B256AAC6DF98655DAF0D0CFF4ABCC577BCC4/assets/views/main.ejs',
    '//package/widgets/721F3B9B2001B256AAC6DF98655DAF0D0CFF4ABCC577BCC4/widget.ejs'
).then(function() {
    Com.Frog.Controllers.Widget.extend('Widget.StreamEmbed', {
    }, {
        prefs: {
            sharelink: {
                type: 'text',
                defaultValue: '',
                label: 'Share link from MS Stream'
            },
            height: {
                type: 'number',
                defaultValue: 400,
                showUnits: 'px',
                label: 'Height'
            }
        },

        packageID: '721F3B9B2001B256AAC6DF98655DAF0D0CFF4ABCC577BCC4',
        /**
         * Constructor. Runs when the widget is first loaded.
         *
         * @method init
         */
        init: function() {},

        'widget.live': function(el, ev, data) {
            this.render('live');
        },
        'render' : function(mode) {
            this.element.html(
                this.view('main.ejs')
            );
            if (mode == 'live') {
                if (this.prefs.sharelink.value == '') {
                    this.element.find('.msstream').html('No video shared');
                } else {
                    var srcArray = this.prefs.sharelink.value.split('https://web.microsoftstream.com/video/');
                    if (srcArray.length > 1) { // if direct share link used, split will have correctly got the idea
                        this.element.find('.msstream').html(
                            '<iframe width="100%" height="'+this.prefs.height.value+'"'+
                            'src="https://web.microsoftstream.com/embed/video/'+srcArray[1]+'?autoplay=false&amp;showinfo=true"'+ 
                            ' allowfullscreen style="border:none;"></iframe>'
                        );
                    } else { // if the embed link used
                        this.element.find('.msstream').html(this.prefs.sharelink.value);
                        this.element.find('.msstream').find('iframe').attr('height', this.prefs.height.value);
                    }
                }
            } else {  // edit mode
                this.element.find('.msstream').html(
                    '<div class="colourbars" style="background: #0000ff; width: 100%; height: '+this.prefs.height.value+'px;">'
                )
            }
        },

        'widget.edit': function(el, ev, data) {
            this.render('edit');
        },
        'widget.save': function(el, ev, data) {
            this.render('edit');
        },

        'widget.updated': function(el, ev, data) {}
    });
});
