Com.Frog.Utils.require(
    '//package/widgets/4189D0612001B7B3BC73EF21CA6EA10B2EC5AEBC15447A3A/assets/styles/main.css',
    '//package/widgets/4189D0612001B7B3BC73EF21CA6EA10B2EC5AEBC15447A3A/assets/views/main.ejs',
    '//package/widgets/4189D0612001B7B3BC73EF21CA6EA10B2EC5AEBC15447A3A/widget.ejs'
).then(function() {
    Com.Frog.Controllers.Widget.extend('Widget.Joinagroup', {
    }, {
        prefs: {
            groupUUID: {
                type: 'hidden', 
                defaultValue: '',
                label: 'Group UUID'
            },
            groupName: {
                type: 'hidden', 
                defaultValue: '',
                label: 'Group Name'
            },
            showbutton: {
                type: 'radio',
                label: 'Select display type',
                vertical: true,
                options: {
                    'Button': 'button',
                    'Image': 'image',
                    'No button (user added automatically)': 'none'
                },
                defaultValue: "button",
                publish: []
            },
            buttonLabel: {
                type: 'text',
                label: 'Button label',
                defaultValue: 'Join this club',
                accordion: 'Design options'
            },
            buttonColour: {
                type: 'radio',
                label: 'Button Colour',
                options: {
                    'Blue': 'btn-primary',
                    'Green': 'btn-success',
                    'Amber': 'btn-warning',
                    'Red': 'btn-danger',
                    'Grey': '',
                },
                defaultValue: 'btn-primary',
                accordion: 'Design options'
            },
            file: {
                type: 'upload',
                label: "Select an image as button",
                showDiscover: false,
                showClipboard: false,
                filter: ['image'],
                view: 'mini',
                sources: ['native'],
                accordion: 'Design options'
            },
            imageHeight: {
                type: 'number',
                showUnits: 'px',
                label: 'Image height',
                defaultValue: 100,
                accordion: 'Design options'
            },
            reloadSite: {
                type: 'radio',
                label: 'After the button is pushed:',
                options: {
                    'Reload site': 'reload',
                    'Do not reload': 'nothing'
                },
                defaultValue: 'nothing',
                accordion: 'Advanced options'
            },
            emailAddresses: {
                type: 'textarea',
                label: 'Send an email whenever a user joins the group (comma separated)',
                placeholder: 'e.g. admin@school.com,office@school.com',
                defaultValue: '',
                accordion: 'Advanced options'
            }
        },

        packageID: '4189D0612001B7B3BC73EF21CA6EA10B2EC5AEBC15447A3A',

        init: function() {},

        'widget.live': function(el, ev, data) {
            this.element.html(
                this.view('main.ejs')
            );
            var warn = this.element.find('.warning'),
                button =  this.element.find('.joinButton'),
                img = this.element.find('.img'),
                btn = this.element.find('.btn');
            
            if (this.prefs.groupUUID.value !== '') { // If the group UUID is set, then hide the warning, if it is not set, disable the button
                warn.hide();
                if (this.prefs.showbutton.value == 'button') { // If the groupUUID is set, make sure it is not disabled, and set the correct look. 
                    button.removeClass('disabled btn-primary btn-success btn-warning btn-danger');
                    button.text(this.prefs.buttonLabel.value).addClass(this.prefs.buttonColour.value);
                    img.hide();
                } else if (this.prefs.showbutton.value == 'image') {
                    img.css('height', this.prefs.imageHeight.value+'px');
                    btn.hide();
                } else { // if the button is not to be displayed, run the function to add the user on loading.
                    button.hide();
                    this.addUserToGroup();
                }
            } else { // Disable the button if the Group UUID is not set
                button.addClass('disabled');
            }
        },

        'widget.edit': function(el, ev, data) { 
            var self = this;
            self.element.html(
                self.view('./widget.ejs') 
            );
            steal.import('frogui/modules/selectusers/selectusers!frog-component').then(function() { /* Import the group selector component */

                var groupName = this.element.find("div.group-select input.groupName"), // Note: Does not work with self
                    groupSelect = this.element.find("div.group-select"); // Note: Does not work with self

                groupSelect.frogui_modules_selectusers({
                    show_label: true,
                    label: 'Search for a group (non-MIS linked)',
                    show_permission: false,
                    show_submit: true,
                    submit_label: 'Search then set Group Identifier', 
                    allow_convert: false,
                    search_users: false,
                    max_selections: 1,
                    profiles: ['admin','staff','parent','governor','student','external admin','external staff'] 
                });
            }.bind(this));  // Note: Does not work with self, requires bind
            
            var warn = self.element.find('.warning');
            warn.hide();
            if (self.prefs.groupUUID.value !== '') {
                warn.html('<h5>Group set: '+$.EJS.clean(self.prefs.groupName.value)+'</h5>');
                warn.addClass('alert-success');
                warn.show();
            }
        },
        'selectusers.submitted': function() { 
            var groupSelect = this.element.find("div.group-select"),
                self = this;
            
            groupSelect.trigger('selectusers.getSelected', function(data) {
                if (!data.groups.length) {
                    return;
                }
                var selectedGroup = data.groups[0].uuid,
                    selectedGroupName = data.groups[0].name,
                    warn = self.element.find('.warning');
                warn.show();
                self.prefs.groupUUID.value = selectedGroup; /* Set the groupUUID preference to the selected group */
                self.prefs.groupName.value = selectedGroupName;  /* Set the groupName preference to the selected group */
                warn.html('<h5>Group to be displayed: '+$.EJS.clean(data.groups[0].name)+'</h5>');
                warn.addClass('alert-success');
            });
        },
        '.joinButton:not(.disabled) click': function () {
            this.addUserToGroup();    
        },
        addUserToGroup: function() { 
            var self = this;
            if (self.prefs.groupUUID.value !== '') {
                var user = FrogOS ? FrogOS.getUser() : self.getUser(); 
                Frog.Model.api('groups.amendMembers', { // This API is not restricted by profile, so students can add themselves to groups without additional rights
                    group_uuid: self.prefs.groupUUID.value,
                    users: JSON.stringify([{uuid: user.uuid, leader: false}])
                },{type: "POST"}).done(function(response) {
                    if (self.prefs.showbutton.value !== 'none') { // Show growl if the button is clicked, not if added on load
                        Frog.Controller.prototype.growl('Added to '+self.prefs.groupName.value,'Join group','app-name',{time:3000, icon: 'externalapps/icon/'+self.packageID });
                        if (self.prefs.emailAddresses.value !== '') {
                            FrogOS.fdp({
                                url: 'email/sendmessage',
                                path: '/api/fdp/1/',
                                type: 'POST',
                                data: { 
                                    subject: 'Someone has joined the group: '+self.prefs.groupName,
                                    message: user.displayname+' ('+user.username+') has joined <b>'+self.prefs.groupName+'</b>.<br><br>You can remove them from this group if required, by opening the Groups & Policies application and editing the group there.',
                                    to: self.prefs.emailAddresses.value,
                                    cc: '',
                                    bcc: '',
                                    send_individual_messages: false
                                }
                            })
                        } // end of Send Email API
                        if (self.prefs.reloadSite.value == 'reload') { // reload site on pressing the join button so that any rules in place are triggered.
                            self.element.closest('div.app-sites').find('div.sites-site-container').first().trigger('reloadSite'); 
                        }
                    }
                }).fail(function(e) {
                    // Report Error
                    if (self.prefs.showbutton.value !== 'none') { // Do not show Growl if the button is not to be shown
                        Frog.Controller.prototype.growl('Failed to join to group','Join group','app-name',{time:3000, icon: 'externalapps/icon/'+self.packageID });
                    }
                });     
            }
        },
        'widget.updated': function(el, ev, data) {}
    });
});
