Com.Frog.Utils.require(
    '//package/widgets/99F982F92001BBDC7E32AF8F3C96E4041520855CC888ECC0/assets/styles/main.css',
    '//package/widgets/99F982F92001BBDC7E32AF8F3C96E4041520855CC888ECC0/assets/views/main.ejs',
    '//package/widgets/99F982F92001BBDC7E32AF8F3C96E4041520855CC888ECC0/assets/views/row.ejs',
    '//package/widgets/99F982F92001BBDC7E32AF8F3C96E4041520855CC888ECC0/widget.ejs'
).then(function() {
    Com.Frog.Controllers.Widget.extend('Widget.GroupswithContextualData', {
    }, {
        prefs: {
            widgetTitle: {
                type: 'text',
                defaultValue: 'Group Contextual Data',
                label: 'Title'
            },
            showAll: {
                type: 'radio',
                label: "Show or hide",
                vertical: true,
                options: {
                    'Show all students': 'all',
                    'Hide students with no contextual data': 'hide'
                },
                defaultValue: "hide",
                publish: [],
                accordion: 'Filters'
            },
            sen: {
                type: 'boolean',
                label: 'Show SEN',
                defaultValue: true,
                accordion: 'Filters'
            },
            eal: {
                type: 'boolean',
                label: 'Show EAL',
                defaultValue: true,
                accordion: 'Filters'
            },
            gt: {
                type: 'boolean',
                label: 'Show G&T',
                defaultValue: true,
                accordion: 'Filters'
            },
            pp: {
                type: 'boolean',
                label: 'Show PP',
                defaultValue: true,
                accordion: 'Filters'
            },
            fsm: {
                type: 'boolean',
                label: 'Show FSM',
                defaultValue: true,
                accordion: 'Filters'
            },
            sc: {
                type: 'boolean',
                label: 'Show Service Children',
                defaultValue: true,
                accordion: 'Filters'
            },
            ic: {
                type: 'boolean',
                label: 'Show In Children',
                defaultValue: true,
                accordion: 'Filters'
            },
            tc: {
                type: 'boolean',
                label: 'Show Traveller Children',
                defaultValue: true,
                accordion: 'Filters'
            },
            eth: {
                type: 'boolean',
                label: 'Show Ethnicity',
                defaultValue: true,
                accordion: 'Filters'
            },
            collectionUUID: {
                type: 'text',
                defaultValue: '',
                label: 'ePortfolio Collection UUID',
                accordion: 'Advanced'
            }
        },

        packageID: '99F982F92001BBDC7E32AF8F3C96E4041520855CC888ECC0',
        /**
         * Constructor. Runs when the widget is first loaded.
         *
         * @method init
         */
        init: function() {},

        /**
         * Event fired by the Site Controller.
         *
         * @event 'widget.live'
         */
        'widget.live': function(el, ev, data) {
            this.element.html(
                this.view('main.ejs')
            );

            steal.import('frogui/modules/selectusers/selectusers!frog-component').then(function() {

                var groupName = this.element.find("div.group-select input.groupName"),
                    groupSelect = this.element.find("div.group-select");

                groupSelect.frogui_modules_selectusers({
                    show_label: false,
                    show_permission: false,
                    show_submit: true,
                    submit_label: 'View group data',
                    allow_convert: false,
                    search_users: false,
                    max_selections: 1,
                    profiles: ['student']
                });
                
            }.bind(this));
        },
       '.remove-group  click': function() {
            this.element.find('.memberlist').find('tr:not(:first)').remove();
        },
        '.copyTableButton click': function() {
            new Clipboard(this.element.find('.copyTableButton'));
        },
        'selectusers.submitted': function() {
                var self = this,
                groupSelect = this.element.find("div.group-select"),
                table = "";
            table += '<tr>'+'<th colspan="2"><b>Student</b></th>'+'<th><b>Username</b></th>';
            
            if (self.prefs.sen.value) {
               table += '<th><b>SEN</b></th>';
            }
            if (self.prefs.eal.value) {
                table += '<th><b>EAL</b></th>';
            }
            if (self.prefs.gt.value) {
                table += '<th><b>GT</b></th>';
            }
            if (self.prefs.pp.value) {
                table += '<th><b>PP</b></th>';
            }
            if (self.prefs.fsm.value) {
                table += '<th><b>FSM</b></th>';
            }
            if (self.prefs.sc.value) {
                table += '<th><b>SC</b></th>';
            }
            if (self.prefs.ic.value) {
                table += '<th><b>In Care</b></th>';
            }
            if (self.prefs.tc.value) {
                table += '<th><b>TC</b></th>';
            }
            if (self.prefs.eth.value) {
                table += '<th><b>Ethnicity</b></th>';
            }

            table += '</tr>';
            self.element.find('.memberlist').html(table);

            
            groupSelect.trigger('selectusers.getSelected', function(data) {
                if (!data.groups.length) {
                    return;
                }
                var selectedGroup = data.groups[0].uuid,
                    classMembers = [];
                
                // Get all members of the group and add them to an array, using their UUID as the key            
                Frog.Model.api('groups.getMembers', {
                    uuid: selectedGroup,
                    ignore_profiles: 'true'
                }).done(function(studentResponse) {
                    var members = studentResponse.data,
                        allGroup = {};

                    members.sort(function(a, b){var a1= a.surname.toLowerCase(), b1= b.surname.toLowerCase();if(a1== b1) return 0; return a1> b1? 1: -1;});
                        
                    $.each(members, function(index,member) {
                        allGroup[member.uuid] = member;
 
                         var row = '<tr class="sturow'+member.uuid+'">'+
                            '<td><img src="'+member.thumbnail+'" style="width: 100px;"></td>'+
                            '<td><span class="studentlist" data-displayname="'+member.displayname+'" data-username="'+member.username+'">'+member.displayname+'</span></td>'+
                            '<td>'+member.username+'</td>';
                       
                        if (self.prefs.sen.value) {
                             row += '<td class="sen'+member.uuid+'"></td>';
                        };
                        if (self.prefs.eal.value) {
                             row += '<td class="eal'+member.uuid+'"></td>';
                        };
                        if (self.prefs.gt.value) {
                             row += '<td class="gt'+member.uuid+'"></td>';
                        };
                        if (self.prefs.pp.value) {
                             row += '<td class="pp'+member.uuid+'"></td>';
                        };
                        if (self.prefs.fsm.value) {
                             row += '<td lass="fsm'+member.uuid+'"></td>';
                        };
                        if (self.prefs.sc.value) {
                             row += '<td class="sc'+member.uuid+'"></td>';
                        };
                        if (self.prefs.ic.value) {
                             row += '<td class="ic'+member.uuid+'"></td>';
                        };
                        if (self.prefs.tc.value) {
                             row += '<td class="tc'+member.uuid+'"></td>';
                        };
                        if (self.prefs.eth.value) {
                             row += '<td class="eth'+member.uuid+'"></td>';
                        };
                        row += '</tr>';
                        self.element.find('.memberlist tr:last').after(row);
                        
                        Frog.Model.api('users.getDataInCategory', {
                            uuid: 'F3A046342004C31D2202BFC5159509053172444CCD360D5F', // category uuid for contextual data
                            user_uuid: member.uuid
                        }).done(function(response) {
                            var List = response.data,
                                count = 0;
                            
                            if (List.fields[0].value == 'yes') {
                                self.element.find('.sen'+member.uuid).html('<span alt="SEN" title="SEN" style="font-size: 36px; color: #208a23;" class="ff-tick-mono"></span>');  
                                if (self.prefs.sen.value) { // Only count if the column is to display
                                    count = 1;
                                }
                            }
                            if (List.fields[1].value == 'yes') {
                                self.element.find('.eal'+member.uuid).html('<span alt="EAL" title="EAL" style="font-size: 36px; color: #208a23;" class="ff-tick-mono"></span>'); 
                                if (self.prefs.eal.value) { 
                                    count = 1;
                                }
                            }
                            if (List.fields[2].value == 'yes') {
                                self.element.find('.gt'+member.uuid).html('<span alt="GT" title="GT" style="font-size: 36px; color: #208a23;" class="ff-tick-mono"></span>');  
                                if (self.prefs.gt.value) { 
                                    count = 1;
                                }
                            }
                            if (List.fields[3].value == 'yes') {
                                self.element.find('.pp'+member.uuid).html('<span alt="PP" title="PP" style="font-size: 36px; color: #208a23;" class="ff-tick-mono"></span>'); 
                                if (self.prefs.pp.value) { 
                                    count = 1;
                                }
                            }
                            if (List.fields[4].value == 'yes') {
                                self.element.find('.fsm'+member.uuid).html('<span alt="FSM" title="FSM" style="font-size: 36px; color: #208a23;" class="ff-tick-mono"></span>');
                                if (self.prefs.fsm.value) { 
                                    count = 1;
                                }
                            }                             
                            if (List.fields[5].value == 'yes') {
                                self.element.find('.sc'+member.uuid).html('<span alt="Service Child" title="Service Child" style="font-size: 36px; color: #208a23;" class="ff-tick-mono"></span>');  
                                if (self.prefs.sc.value) { 
                                    count = 1;
                                }
                            }   
                            if (List.fields[6].value == 'yes') {
                                self.element.find('.ic'+member.uuid).html('<span alt="In Care" title="In Care" style="font-size: 36px; color: #208a23;" class="ff-tick-mono"></span>');  
                                if (self.prefs.ic.value) { 
                                    count = 1;
                                }
                            }   
                            if (List.fields[7].value == 'yes') {
                                self.element.find('.tc'+member.uuid).html('<span alt="Traveller Child" title="Traveller Child" style="font-size: 36px; color: #208a23;" class="ff-tick-mono"></span>'); 
                                if (self.prefs.tc.value) { 
                                    count = 1;
                                }
                            }   
                            if (self.prefs.eth.value) {
                                self.element.find('.eth'+member.uuid).html(List.fields[8].value); 
                            }

                            if (count == 0 && self.prefs.showAll.value == "hide") {
                                self.element.find('.sturow'+member.uuid).remove();
                            }
                        }); // end of category

                    }) // end of members loop
                    
                }).fail(function(e) { // End of groups.getMembers                       
                        console.log("failed to get group members");
                        Frog.Controller.prototype.growl('Group Information cannot be retrieved','Assignment Opens Report','app-name',{time:'5000', icon: 'externalapps/icon/258F69872001B9D91161EFF95A30CA00DC360EDC59FBEFB3'});
                });
            }); // end of group trigger
        },
        
        '.studentlist {click}': function(ev) {
            if (this.prefs.collectionUUID.value !== '') {
                var kid_username = ev[0].dataset.username,
                    kid_displayname = ev[0].dataset.displayname,
                    eportfoliolist = this.element.find("#eportfoliolist");
                eportfoliolist.empty()

                Frog.Model.api('sites.getSitesByAssociation', {
                    all: "true",
                    limit: "50",
                    offset: "0",
                    order: {name: "asc"},
                    query: kid_username,
                    requires: {column: "false"},
                    scope: "personal",
                    sitegroup_uuid: this.prefs.collectionUUID.value,
                    type:"recipient_eportfolios",
                    view: "eportfolios"
                }).done(function(thisResponse) {
                    if (thisResponse.data[0].children.length > 0) {
                        var link = thisResponse.data[0].children[0].link,
                            name = thisResponse.data[0].children[0].name;
                        eportfoliolist.append(
                            '<a href="#" style="font-size: 20pt; font-weight: bold; padding: 10px" class="eplannergq" alt="Planner" data-site-uuid-cke="'+link+'" data-site-link="'+name+'">Open '+kid_displayname+'\'s ePortfolio</a>'
                        );
                        this.element.find('.eplannergq').trigger('click');
                    } else {
                        eportfoliolist.html('No ePortfolio found for '+kid_displayname);
                    }
                }.bind(this));
            }
        },
        'widget.edit': function(el, ev, data) {
            this.element.html(
                this.view('./widget.ejs')
            );
        },


        'widget.updated': function(el, ev, data) {}
    });
});
