Com.Frog.Utils.require(
    '//package/widgets/4DF6D19D2001B005B8C20F69C72CC60D7CDF161CCF2766E0/assets/styles/main.css',
    '//package/widgets/4DF6D19D2001B005B8C20F69C72CC60D7CDF161CCF2766E0/assets/views/main.ejs',
    '//package/widgets/4DF6D19D2001B005B8C20F69C72CC60D7CDF161CCF2766E0/widget.ejs'
).then(function() {
    Com.Frog.Controllers.Widget.extend('Widget.GoogleSearch', {
    }, {
        prefs: {
            "btnColor": {
                "type": "colourpicker",
                "label": "preference.btn.color.label",
                "defaultValue": "#ff4500"
            },
            "btnTextColor": {
                "type": "colourpicker",
                "label": "preference.btn.text.label",
                "defaultValue": "#ffffff"
            }
        },

        setup: function() {
            this.getDefaultValues();
            this._super.apply(this, arguments);
        },

        packageID: '4DF6D19D2001B005B8C20F69C72CC60D7CDF161CCF2766E0',
        /**
         * Constructor. Runs when the widget is first loaded.
         *
         * @method init
         */
        init: function() {
            this.getDefaultValues();
        },

        getDefaultValues: function() {
            var randomColor = (Math.floor(Math.random() * (16777215 - 0)) + 0).toString(16),
                textContrast = (parseInt(randomColor, 16) > 0xffffff / 2) ? '000000' : 'FFFFFF';

            this.prefs.btnColor.label = this._(this.prefs.btnColor.label);
            this.prefs.btnTextColor.label = this._(this.prefs.btnTextColor.label);

            // gets a random colour... 16777215 == ffffff
            this.prefs.btnColor.defaultValue = '#' + randomColor;
            this.prefs.btnTextColor.defaultValue = '#' + textContrast;
        },

        /**
         * Event fired by the Site Controller.
         *
         * @event 'widget.live'
         */
        'widget.live': function(el, ev, data) {
            this.element.html(
                this.view('main.ejs')
            );
        },

        /**
         * Event fired by the Site Controller. Tells the widget that the site is in Edit Mode.
         *
         * @event 'widget.edit'
         */
        'widget.edit': function(el, ev, data) {
            this.element.html(
                this.view('./widget.ejs')
            );
        }
    });
});
