Com.Frog.Utils.require(
    '//package/widgets/8C586AA82001BCFFD3D8CFB2F2C3C90E2E66D03CA8FD97BF/assets/styles/main.css',
    '//package/widgets/8C586AA82001BCFFD3D8CFB2F2C3C90E2E66D03CA8FD97BF/assets/views/main.ejs',
    '//package/widgets/8C586AA82001BCFFD3D8CFB2F2C3C90E2E66D03CA8FD97BF/widget.ejs',
    '//package/widgets/8C586AA82001BCFFD3D8CFB2F2C3C90E2E66D03CA8FD97BF/edit.ejs'
).then(function() {
    Com.Frog.Controllers.Widget.extend('Widget.PagetoExternalLink', {
    }, {
        prefs: {
            "link_label": {
                type:"text",
                defaultValue:"label",
                label:"Link Label"
            },
            "link_url": {
                type:"text",
                defaultValue:"https://www.bbc.co.uk",
                label:"Link URL"
            },
            "page": {
                 type: "pagepicker",
                 label: "Override Page",
                 defaultValue: JSON.stringify({
                     page_uuid:'',
                     site_uuid:''
                 })
             }
        },

        packageID: '8C586AA82001BCFFD3D8CFB2F2C3C90E2E66D03CA8FD97BF',
        /**
         * Constructor. Runs when the widget is first loaded.
         *
         * @method init
         */
        init: function() {},

        /**
         * Event fired by the Site Controller.
         *
         * @event 'widget.live'
         */
        'widget.live': function(el, ev, data) {
            
            var page_opts = JSON.parse(this.prefs.page.value),
            $menu = this.element.closest('.sites_core').find('.sites_menu');

            this.element.html(
                this.view('./widget.ejs')
            );

            if (!page_opts.page_uuid || !this.prefs.link_url.value || !$menu) {
                return;
            }

            $menu.find('a[data-uuid=' + page_opts.page_uuid + ']').on('click', function(ev) {
                var target = this.prefs.link_url.value;
                debugger;
                if (target && this.state === 'live') {
                    ev.stopImmediatePropagation();
                    if (target.match(/http[s]*:\/\//g)) {
                        window.open(target, '_blank');
                        return;
                    }
                
                    if (target.match(/\/[a-z0-9.]+\/[a-z0-9_.]+\//gi)) {
                        FrogOS.openSite({ site: target });
                        return;
                    }
                
                    $menu.trigger('sites.changeLocation', {
                        uuid: target
                    });
                }
            }.bind(this));
        },

        /**
         * Event fired by the Site Controller. Tells the widget that the site is in Edit Mode.
         *
         * @event 'widget.edit'
         */
        'widget.edit': function(el, ev, data) {
            this.element.html(
                this.view(
                    './edit.ejs',
                    {
                        link_label: this.prefs.link_label
                    }
                )
            );
        },

        /**
         * Event fired by the Site Controller. Tells the widget that something has been changed during editing.
         *
         * @event 'widget.updated'
         */
        'widget.updated': function(el, ev, data) {}
    });
});
