Com.Frog.Utils.require(
    '//package/widgets/4783AD2B2001BE7AC359CF9868142601DE2C7E5C19EFA1B7/assets/styles/main.css',
    '//package/widgets/4783AD2B2001BE7AC359CF9868142601DE2C7E5C19EFA1B7/assets/views/main.ejs',
    '//package/widgets/4783AD2B2001BE7AC359CF9868142601DE2C7E5C19EFA1B7/widget.ejs'
).then(function() {
    Com.Frog.Controllers.Widget.extend('Widget.ExamTimetables', {
    }, {
        prefs: {
            title: {
                type: "text",
                label: "Title",
                defaultValue: "Mock Exam Timetable"
            },
            jdata: {
                type: "textarea",
                label: "Enter your data here (upn keyed json format)",
                placeholder: "",
                defaultValue: "",
                hidden: false
            },
            "pdf_show": {
                type:"boolean",
                defaultValue: true,
                label:"Allow PDF download",
                accordion: 'settings.advanced'
            }
        },

        packageID: '4783AD2B2001BE7AC359CF9868142601DE2C7E5C19EFA1B7',
        /**
         * Constructor. Runs when the widget is first loaded.
         *
         * @method init
         */
        init: function() {
			var myrecord;
        },
        
        'broadcast.selectedUser': function(el, ev, options) {
			console.log("broadcast fired");
            console.log("upn: "+options.model.attr('pupil_number'));
            this.renderTimetable(options.model.attr('pupil_number'), options.model.attr('displayname'));
        },
        
        renderTimetable: function(user_upn, user_name) {
            this.element.find('[data-name="exams"]').hide();
            this.element.find('[data-name="pdfbtn"]').hide();
            this.element.find('[data-name="exams"] tbody').empty();
            this.element.find('[data-name="messages"]').empty();
            this.element.find('[data-name="title"]').html(this.prefs.title.value);
            this.element.find('[data-name="student"]').html(user_name);
            console.log("searching for UPN: "+user_upn);

            try {
                var json = JSON.parse(this.prefs.jdata.value);
                var found = false;
                for (var key in json) {
                    if (json.hasOwnProperty(key)) {
                        if (key == user_upn) {
                            myrecord = json[key];
                            found = true;
                            console.log('match!', json[key]);
                            $.each(myrecord, function (index, exam) {
                                this.element.find('[data-name="exams"] tbody').append('<tr><td>'+exam.Date+'</td><td>'+exam.Time+'</td><td>'+exam.CompCode+'</td><td>'+exam.CompTitle+'</td><td>'+exam.Duration+'</td><td>'+exam.Room+'</td><td>'+exam.Seat+'</td></tr>');
                            }.bind(this)); 
                            this.element.find('[data-name="exams"]').show();
                            if (this.prefs.pdf_show.value) {
                                this.element.find('[data-name="pdfbtn"]').show();
                            }
                        }
                    }
                }
                if (found == false) {
                    this.element.find('[data-name="messages"]').html("No timetable found");
                }
            }
            catch (e) { 
                console.log("error - invalid json")
                this.element.find('[data-name="messages"]').html("No timetable found");
            }
        },
        
        
        
        renderPdf: function() {
            $.getScript("https://cdnjs.cloudflare.com/ajax/libs/jspdf/1.4.1/jspdf.min.js").done(function(script, textStatus) {
                var doc = new jsPDF('landscape')
                var pageHeight = doc.internal.pageSize.getHeight() - 20;
                var page = 1;

                doc.setLineWidth(0.1)
                this.addPdfTitle(doc);
                this.addPdfTableHeader(doc,page);

                var row = 53;
                $.each(myrecord, function (index, exam) {
                    if (row >= pageHeight) {
                        doc.addPage();
                        page++;
                        this.addPdfTableHeader(doc,page);
                        row = 28;
                    }
                    doc.text(20, row, exam.Date)
                    doc.text(45, row, exam.Time)
                    doc.text(65, row, exam.CompCode)
                    doc.text(90, row, exam.CompTitle)
                    doc.text(185, row, exam.Duration)
                    doc.text(205, row, exam.Room)
                    doc.text(235, row, exam.Seat)
                    doc.line(18, (row+3), 245, (row+3))
                    row += 8;
                }.bind(this)); 

                doc.save('timetable.pdf');
            }.bind(this));

        },
        
        addPdfTitle: function(doc) {
            doc.setFontSize(22)
            doc.text(20, 20, this.prefs.title.value)
            doc.setFontSize(16)
            doc.text(20, 30, this.element.find('[data-name="student"]').html())
        },
        
        addPdfTableHeader: function(doc, page) {
            var  xpos = 45;
            if (page>1) {
                xpos = 20;
            }
            doc.setFontType('bold')
            doc.setFontSize(10)
            doc.text(20, xpos, "Date")
            doc.text(45, xpos, "Time")
            doc.text(65, xpos, "Code")
            doc.text(90, xpos, "Title")
            doc.text(185, xpos, "Duration")
            doc.text(205, xpos, "Room")
            doc.text(235, xpos, "Seat")
            doc.setFontType('normal')
            doc.line(18, (xpos+3), 245, (xpos+3))
        },

        /**
         * Event fired by the Site Controller.
         *
         * @event 'widget.live'
         */
        'widget.live': function(el, ev, data) {
            this.element.html(
                this.view('main.ejs')
            );
            
            var currentuser = FrogOS.getUser();
            if (currentuser.profile.type !== "parent") {
                this.renderTimetable(currentuser.attr('pupil_number'), currentuser.displayname);
            }
            
        },
        
        '[data-name="pdfbtn"] click': function(el, ev) {
            this.renderPdf();
        },

        /**
         * Event fired by the Site Controller. Tells the widget that the site is in Edit Mode.
         *
         * @event 'widget.edit'
         */
        'widget.edit': function(el, ev, data) {
            this.element.html(
                this.view('./widget.ejs')
            );
        },

        /**
         * Event fired by the Site Controller. Tells the widget that something has been changed during editing.
         *
         * @event 'widget.updated'
         */
        'widget.updated': function(el, ev, data) {}
    });
});
