Com.Frog.Utils.require(
    '//package/widgets/65ACB9C22001B618DD170FF26E5CB509212EEBBC132C48FA/assets/styles/main.css',
    '//package/widgets/65ACB9C22001B618DD170FF26E5CB509212EEBBC132C48FA/assets/views/main.ejs',
    '//package/widgets/65ACB9C22001B618DD170FF26E5CB509212EEBBC132C48FA/widget.ejs'
).then(function() {
    Com.Frog.Controllers.Widget.extend('Widget.ePortfolioTutorGroups', {
    }, {
        prefs: {
            collectionUUID: {
                type: 'text',
                defaultValue: '',
                label: 'ePortfolio Collection UUID'
            },
            groupType: {
                type: 'list',
                defaultValue: 'registration',
                label: 'Group Type',
                options: {
                    'Class': 'class',
                    'Club': 'club',
                    'House': 'house',
                    'Job Role': 'jobrole',
                    'Registration (Tutor)': 'registration',
                    'Year': 'year'
                }
            }
        },

        packageID: '65ACB9C22001B618DD170FF26E5CB509212EEBBC132C48FA',
        /**
         * Constructor. Runs when the widget is first loaded.
         *
         * @method init
         */
        init: function() {},

        /**
         * Event fired by the Site Controller.
         *
         * @event 'widget.live'
         */
        'widget.live': function(el, ev, data) {
            var userProfile = FrogOS ? FrogOS.getUser().profile.type : this.getUser().profile.type;
            this.element.html(
                this.view('main.ejs')
            );
            var reglist = this.element.find("#reglist"),
                line1 = this.element.find(".line1"),
                line2 = this.element.find(".line2");
                line1.css('display', 'none');
                line2.css('display', 'none');
            if (userProfile != "admin" && userProfile != "staff") {
                    reglist.html('This information is only available for Staff and Admin profiles.')
            } else {
                var studentlist = this.element.find("#studentlist"),
                    eportfoliolist = this.element.find("#eportfoliolist");
                
                if (this.prefs.collectionUUID.value == '') {
                    studentlist.html('<h3>No collection UUID set</h3>');
                } else {
                    studentlist.empty()
                }
                reglist.empty()
                eportfoliolist.empty()

                Frog.Model.api('groups.getGroupList', {
                    type: this.prefs.groupType.value,
                    unlinked_external: 'true'
                }).done(function(listResponse) {
                    var classes = listResponse.data;
                    reglist.empty()
                    $.each(classes, function(index,clss) {
                        reglist.append(
                            '<span class="regclass '+clss.uuid+'" data-uuid="'+clss.uuid+'">'+clss.name+'</span>'
                        );
                    });
                });
            }

            this.element.off('click','.regclass').on('click','.regclass', function(ev) {
                var group_uuid = ev.target.dataset.uuid,
                    studentlist = this.element.find("#studentlist");
            
                this.element.find('.regclass').removeClass('selected');
                this.element.find('.regclass.'+ group_uuid).addClass('selected');
                line1.css('display', 'block');
                line2.css('display', 'none');
            
                Frog.Model.api('groups.getMembers', {
                    uuid: group_uuid,
                    ignore_profiles: 'true'
                }).done(function(stuResponse) {
                    studentlist.empty()
                    eportfoliolist.empty()
                    var students = stuResponse.data;
                    $.each(students, function(index1,student) {
                        studentlist.append(
                            '<span class="studentlist" data-displayname="'+student.displayname+'" data-username="'+student.username+'">'+student.displayname+'</span>'
                        );
                    });
                });
            }.bind(this));
    
            this.element.off('click','.studentlist').on('click','.studentlist', function(ev) {
                var kid_username = ev.target.dataset.username,
                kid_displayname = ev.target.dataset.displayname,
                eportfoliolist = this.element.find("#eportfoliolist");
                eportfoliolist.empty()
                line2.css('display', 'block');
                Frog.Model.api('sites.getSitesByAssociation', {
                    all: "true",
                    limit: "50",
                    offset: "0",
                    order: {name: "asc"},
                    query: kid_username,
                    requires: {column: "false"},
                    scope: "personal",
                    sitegroup_uuid: this.prefs.collectionUUID.value,
                    type:"recipient_eportfolios",
                    view: "eportfolios"
                }).done(function(thisResponse) {
                    if (thisResponse.data[0].children.length > 0) {
                        var link = thisResponse.data[0].children[0].link,
                            name = thisResponse.data[0].children[0].name;
                        eportfoliolist.append(
                            '<a href="#" style="font-size: 20pt; font-weight: bold; padding: 10px" class="eplannergq" alt="Planner" data-site-uuid-cke="'+link+'" data-site-link="'+name+'">Open '+kid_displayname+'\'s ePortfolio</a>'
                        );
                        this.element.find('.eplannergq').trigger('click');
                    } else {
                        eportfoliolist.html('No ePortfolio found for '+kid_displayname);
                    }
                }.bind(this));
            }.bind(this));   
        },

        /**
         * Event fired by the Site Controller. Tells the widget that the site is in Edit Mode.
         *
         * @event 'widget.edit'
         */
        'widget.edit': function(el, ev, data) {
            this.element.html(
                this.view('./widget.ejs')
            );
        },

        /**
         * Event fired by the Site Controller. Tells the widget that something has been changed during editing.
         *
         * @event 'widget.updated'
         */
        'widget.updated': function(el, ev, data) {}
    });
});
