/**
 * @class Widget.SiteSearch.Models.Site
 *
 * Site model for use by the SiteLink widget.
 * This is not like most models, in that it allows a set of default attribute
 * values to be passed into the search function. This allows the defaults to
 * be switched easily between "live" and "edit" modes.
 */
Frog.Widget.Model.extend('Widget.Models.Eportfolio', {
    getMyEportfolios: function (params) {
        params = $.extend({}, params, {'type': 'my_eportfolios'});

        return this.api('sites.getSitesByAssociation',
            params,
            {
            "dataType": "json sites",
            "type" : "GET",
            "converters": {
                "json sites": function( res ) {
                    var sites = Object.values(res.data[0].children);

                    return Lib.Models.Site.models(sites);
                }
            }
        });
    },

    getMyChildsEportfolios: function (params) {
        params = $.extend({}, params, {'type': 'my_childs_eportfolios'});

        return this.api('sites.getSitesByAssociation',
            params,
            {
                "dataType": "json sites",
                "type" : "GET",
                "converters": {
                    "json sites": function( res ) {
                        var sites = Object.values(res.data[0].children);

                        return Lib.Models.Site.models(sites);
                    }
                }
            });
    }
}, {});
