Com.Frog.Utils.require(
    '//package/widgets/144406D82001B262A6A8EF35474975064B3FB27C3FD8048E/assets/styles/main.css',
    '//package/widgets/144406D82001B262A6A8EF35474975064B3FB27C3FD8048E/assets/views/main.ejs',
    '//package/widgets/144406D82001B262A6A8EF35474975064B3FB27C3FD8048E/widget.ejs'
).then(function() {
    Com.Frog.Controllers.Widget.extend('Widget.Dash', {
    }, {
        prefs: {
            emailaddresses: {
                type: 'textarea',
                label: 'Add email addresses here (comma separated)',
                placeholder: 'e.g. admin@school.com,office@school.com',
                defaultValue: ''
            },
            emailSubject: {
                type: 'Text',
                label: 'Email Subject',
                defaultValue: 'Pastoral Support Request'
            },
            emailMessage: {
                type: 'textarea',
                label: 'Email message',
                defaultValue: 'Please provide immediate support in my classroom'
            },
            buttonText: {
                type: 'Text',
                label: 'Widget Title',
                defaultValue: 'Support Request'
            },
            bcccheck: {
                type: 'boolean',
                label: 'Hide email addresses from recipients?',    
                defaultValue: 'true',
                accordion: 'Advanced'
            },
            teachername: {
                type: 'boolean',
                label: "Include teacher's name in email subject",    
                defaultValue: 'true',
                accordion: 'Advanced'
            },
            buttonicon: {
           		type: "list",
           		label: "Icon for widget",
           		defaultValue: "exclamation-triangle",
           		options : {
					"Alert" : "exclamation-triangle",
                    "Email": "envelope",
                    "Help": "question-circle",
                    "Information": "info-circle"
           		},
                accordion: 'Design'
            },
            iconcolour: {
                type: 'colourpicker',
                label: 'Icon colour',
                defaultValue: '#FF0000',
                accordion: 'Design'
            }
        },
        edit_mode : false,
        packageID: '144406D82001B262A6A8EF35474975064B3FB27C3FD8048E',
        /**
         * Constructor. Runs when the widget is first loaded.
         *
         * @method init
         */
        init: function() {},

        /**
         * Event fired by the Site Controller.
         *
         * @event 'widget.live'
         */
        'widget.live': function(el, ev, data) {
            this.element.html(
                this.view('main.ejs')
            );
            this.edit_mode = false;
            this.renderInEdit();
        },
        'widget.save': function(el, ev, data) {
            this.element.html(
                this.view('main.ejs')
            );
            this.edit_mode = true;
            this.renderInEdit();
        },
        /**
         * Event fired by the Site Controller. Tells the widget that the site is in Edit Mode.
         *
         * @event 'widget.edit'
         */
        'widget.edit': function(el, ev, data) {
            this.element.html(
                this.view('main.ejs')
            );
            this.edit_mode = true;
            this.renderInEdit();
        },
        renderInEdit : function() {
             this.element.find('.heading').text(this.prefs.buttonText.value);           

             var icon = 'fa-'+this.prefs.buttonicon.value,
                 iconClass = this.element.find('.fileicon');
             iconClass.css('color', this.prefs.iconcolour.value);
             
             iconClass.removeClass('fa-exclamation-triangle');
             iconClass.removeClass('fa-info-circle');
             iconClass.removeClass('fa-question-circle');
             iconClass.removeClass('fa-envelope');
		 	 iconClass.addClass(icon);
        },
        '.dashButton {click}': function() {
            this.element.find('.heading').text(this.prefs.buttonText.value);
            var user = FrogOS ? FrogOS.getUser() : this.getUser(),
                to = this.prefs.emailaddresses.value,
                subject = this.prefs.emailSubject.value;
            if (this.prefs.emailaddresses.value != '' && this.edit_mode === false) { //has the email field been filled out and is the user in edit mode and clicked the button accidentally
                if (user.email != '') { // Does Frog have the logged in users's email address? If so, send them a copy of the email
                    to = to+','+user.email;
                }
                if (this.prefs.teachername.value === true) { // Does the school want the teacher's name in the email subject?
                    subject = this.prefs.emailSubject.value+' - '+user.displayname
                }
                var room = this.element.find('input[name="room"]');
                FrogOS.fdp({
                    url: 'email/sendmessage',
                    path: '/api/fdp/1/',
                    type: 'POST',
                    data: { 
                        subject: subject,
                        message: '<b>'+user.displayname+'</b><br> '+this.prefs.emailMessage.value+' <br><br><b>Room:</b> '+room.val(),
                        to: to,
                        cc: '',
                        bcc: '',
                        send_individual_messages: this.prefs.bcccheck.value
                    }
                }).done(function(response) {
                    this.element.find('.heading').text('Email sent'); // change the widget heading to show the email has been sent
                    setTimeout(function () {
                        this.element.find('.heading').text(this.prefs.buttonText.value); 
                    }.bind(this), 5000); // reset the heading after 5 seconds
                }.bind(this)).fail(function(e) {
                    this.element.find('.heading').text('Cannot send email');
                });
            } //end of editing check 
            else {
                this.element.find('.heading').text('No email address specified or you are currently editing the page');
            }
        },
        /**
         * Event fired by the Site Controller. Tells the widget that something has been changed during editing.
         *
         * @event 'widget.updated'
         */
        'widget.updated': function(el, ev, data) {}
    });
});
