Frog.Model.extend('Widget.Models.Resource', {
    attributes: {
        url: 'string',
        mimeType: 'string',
        fileName: 'string',
        fileExt: 'string',
        sourceType: 'string'
    }
}, {
    init: function(data) {
        var self = this;
        $.each(data, function(key, value) {
            self.attr(key, value);
        });
    },

    setUrl: function(value) {
        this.url = value;
    },

    getUrl: function() {
        var url = this.url;

        if (url !== null) {
            // Remove trailing slashes
            url = url.replace(/\/+$/, '');
            // Append file extension if not already present
            if (!url.match(new RegExp(this.fileExt + '$', 'i'))) {
                url = url + '.' + this.fileExt;
            }
        }
        return url;
    },

    setMimeType: function(value) {
        this.mimeType = value;
    },

    getMimeType: function() {
        return this.mimeType;
    },

    setFileName: function(value) {
        this.fileName = value;
    },

    getFileName: function() {
        return this.fileName;
    },

    setSourceType: function(value) {
        this.mimeType = value;
    },

    getSourceType: function() {
        return this.sourceType;
    },

    setFileExt: function(value) {
        this.fileExt = value;
    },

    getFileExt: function() {
        return this.fileExt;
    }
});