Com.Frog.Utils.require(
    '//package/widgets/C2E2548C2001B6412D6A9F1317FAA0088261649CD08E1773/assets/styles/main.css',
    '//package/widgets/C2E2548C2001B6412D6A9F1317FAA0088261649CD08E1773/assets/views/main.ejs',
    '//package/widgets/C2E2548C2001B6412D6A9F1317FAA0088261649CD08E1773/assets/views/row.ejs',
    '//package/widgets/C2E2548C2001B6412D6A9F1317FAA0088261649CD08E1773/widget.ejs'
).then(function() {
    Com.Frog.Controllers.Widget.extend('Widget.PersonalData', {
    }, {
        prefs: {
             preselected_form: {
                type: 'PreselectedForm',
                label: 'Select a Form',
                defaultValue: JSON.stringify({"formUuid": "", "userCanOverrideFilters": false})
            },
            identifier: {
                type: 'radio',
                label: 'Identifier',
                vertical: true,
                options: {
                    'Frog UUID': 'uuid',
                    'Username': 'username',
                    'UPN': 'upn'
                },
                defaultValue: 'username',
                publish: []
            },
            limit: {
                type: 'number',
                label: 'Number of records to display per user',
                defaultValue: 1
            },
            styling: {
                type: 'textarea',
                label: 'CSS for Displayed data',
                defaultValue: '',
                accordion: 'Design'
            },
            UserPickerField: {
                type: 'hidden',
                label: 'User Field UUID',
                defaultValue: ''
            },
            DataField: {
                type: 'hidden',
                label: 'Data Field UUID',
                defaultValue: ''
            }
        },

        packageID: 'C2E2548C2001B6412D6A9F1317FAA0088261649CD08E1773',
        allUsernames: {},
        allUPNs: {},
        noRecords: 0,
        currentRecord: 0,

        init: function() {},

        'widget.live': function(el, ev, data) {
            this.element.html(
                this.view('main.ejs')
            );
            this.displayData();
        },

        'widget.edit': function(el, ev, data) {
            var self = this;
            var user = FrogOS ? FrogOS.getUser() : self.getUser();
            if (user.profile.name == 'Admin' || user.profile.name == 'Staff' || user.profile.name == 'Super User') {
                self.element.html(
                    self.view('./widget.ejs')
                );
                var formUUID = JSON.parse(self.prefs.preselected_form.value).formUuid;
                if (formUUID == 'default' || formUUID == '') {
                    self.element.find('.instructions_2').hide();
                } else {
                    self.element.find('.form_uuid').text(formUUID);
                }
            } else { 
                self.element.html(
                    self.view('main.ejs')
                ); 
            }
        },
        
        '.get_all click': function() { // This function creates arrays so make it easier to convert username or upn to Frog UUID on import.
            var self = this;
            var importHold = self.element.find('.import_hold');
            var importComplete = self.element.find('.import_complete');
            var loadingGif = self.element.find('.form_loading');
            
            importHold.show();
            loadingGif.show();
            FrogOS.fdp({
                url: 'user/get',
                path: '/api/fdp/2/',
                type: 'GET',
            }).done(function(usersResponse) {
                var users = usersResponse.response;
                $.each(users, function(index, user) {
                    self.allUPNs[ user.pupil_number ] = user.uuid;
                    self.allUsernames[ user.username ] = user.uuid;
                });
                importHold.hide();
                importComplete.show();
                loadingGif.hide();
                if (self.prefs.identifier.value !== 'uuid') {
                    self.element.find('.import').show();
                }
            }).fail(function(e) {
                self.showGrowl('Failed to get all users');
            });
        },
        
        '.import click': function() {
            var self = this;
            var submittedData = self.element.find('.input_data').val();
            var jsonData = self.csvToJSON(submittedData);
            
            self.currentRecord = 0;
            self.element.find('.fails ul').empty();
            self.element.find('.count').hide();
            self.element.find('.fails').hide();
            self.noRecords = Object.keys(jsonData).length;
            $.each(jsonData, function(index, entry) {
                self.addToForm(index,entry);
            });   
            self.element.find('.input_data').val('');
        },
        
        csvToJSON: function(csv) {
            var lines = csv.split('\n');
            var result = {};
            var headers = lines[0].split(/\t|,/);

            for(var i = 1; i < lines.length-1; i++) {
                var currentline = lines[i].split(/\t|,/);
                result[currentline[0]] = {};
                for(var j = 1; j < headers.length; j++) {
                    result[currentline[0]][headers[j]] = currentline[j];
                }
            }          
            return result;
        },
        
        addToForm: function(userID,entry) {
            var self = this;
            var formUUID = JSON.parse(self.prefs.preselected_form.value).formUuid;
            var entry = JSON.stringify(entry);
            var idString = userID;
  
            if (self.prefs.identifier.value == 'upn') {
                userID = self.allUPNs[userID];
            } else if (self.prefs.identifier.value == 'username') {
                userID = self.allUsernames[userID];
            }   
            
            if (userID) { // if the username or upn or uuid is missing from the spreadsheet, do not add to the form
                self.currentRecord += 1;       
                Frog.Model.api('form.submission', {
                    notify_creator: '0',
                    site_uuid: self.options.site_uuid,
                    uuid: formUUID,
                    email_user: false,
                    fields: [
                        {
                            form_uuid: formUUID,
                            uuid: self.prefs.UserPickerField.value,
                            value: userID,
                            type: 'userselect',
                            label: 'User',
                            email_to_selected_user: 'false'
                        },
                        {
                            form_uuid: formUUID,
                            uuid: self.prefs.DataField.value,
                            value: entry,
                            type: 'textarea',
                            label: 'Data'
                        }
                    ]
                },{
                    type: 'POST'
                }).done(function(resp) {
                    self.element.find('.count').show();
                    self.element.find('.imported_count').text(self.currentRecord+' / '+self.noRecords);
                }).fail(function(e) {
                    self.showGrowl('Failed to write to Form');
                });
            } else {
                self.showGrowl('User details not present');
                self.element.find('.fails').show();
                self.element.find('.fails ul').append('<li>'+idString+'</li>');
            }
        },
        
        'widget.save': function(el, ev, data) {
            var self = this;
            var formUUID = JSON.parse(self.prefs.preselected_form.value).formUuid;
            
            if (formUUID !== 'default' && formUUID !== '') {
                self.element.find('.instructions_2').show();
                if (self.prefs.identifier.value !== 'uuid' ) {
                    self.element.find('.import').hide();
                } else {
                    self.element.find('.import').show();
                }           
                Frog.Model.api('form.get', {
                    uuid: formUUID,
                    limit: '1',
                    summary: 'true'
                }).done(function(response) {
                    var formStructure = response.data;
                    if (formStructure.fields[0].type === 'userselect' && formStructure.fields[1].type === 'textarea') {
                        self.prefs.UserPickerField.value = formStructure.fields[0].uuid;
                        self.prefs.DataField.value = formStructure.fields[1].uuid;
                        self.element.find('.form_uuid').text(formUUID);
                    } else {
                        self.showGrowl('Form fields do not match requirements');
                        self.element.find('.instructions_2').hide();
                        self.prefs.preselected_form.value = JSON.stringify({"formUuid": "", "userCanOverrideFilters": false});
                    }
                }).fail(function(e) {
                    self.showGrowl('Failed to get Form');
                });
            }
        },
        
        displayData: function() {
            var self = this;
            var user = FrogOS ? FrogOS.getUser() : self.getUser();
            var formUUID = JSON.parse(self.prefs.preselected_form.value).formUuid;
            var personalDataDisplay = self.element.find('.personal_data');

            personalDataDisplay.attr('style', self.prefs.styling.value);
            if (formUUID !== 'default' && formUUID !== '') {
                Frog.Model.api('dataviewer.gettable', {
                    content_uuid: formUUID,
                    current_user_only: 'false',
                    form_uuid: formUUID,
                    limit: self.prefs.limit.value,
                    module: 'form',
                    offset: '0',
                    sort_dir: 'DESC',
                    sort_field: 'date'
                }).done(function(response) {
                    var personalData = response.data;
                    $.each(personalData, function(index, entry) {
                        var data = entry.fields[1].responses[0].response;
                        data = JSON.parse(data);
                        $.each(data, function(index, datum) {
                            if (datum) {
                                personalDataDisplay.append(
                                    self.view('row.ejs', {
                                        index: index,
                                        datum: datum
                                    })
                                )
                            }
                        }) // end of data $.each
                    }); // end of personalData $.each
                }); // end of API response
            } // end of IF FormUUID set
        },
        
        showGrowl: function(string) {
            var icon = 'externalapps/icon/'+this.packageID;
            Frog.Controller.prototype.growl(string,'Data to Form','app-name',{time:'5000', icon: icon});
        },
        
        'widget.updated': function(el, ev, data) {}
    });
});
