Com.Frog.Utils.require(
    '//package/widgets/3B876F512001BDF3427BEFC4A4785B04A982DFCCD48CCFD1/assets/styles/main.css',
    '//package/widgets/3B876F512001BDF3427BEFC4A4785B04A982DFCCD48CCFD1/assets/views/main.ejs',
    '//package/widgets/3B876F512001BDF3427BEFC4A4785B04A982DFCCD48CCFD1/assets/views/card_1.ejs',
    '//package/widgets/3B876F512001BDF3427BEFC4A4785B04A982DFCCD48CCFD1/widget.ejs'
).then(function() {
    Com.Frog.Controllers.Widget.extend('Widget.CardSort', {
    }, {
        prefs: {
            'cardstext': {
                "type": "textarea",
                "label": "Text for Cards, use ; to separate statements",
                "placeholder": "Example 1;Example 2",
                "defaultValue": ""
            },
            'bgimage': {
                type: 'upload',
                label: "Select a background image",
                showDiscover: false,
                showClipboard: false,
                filter: ['image'],
                view: 'mini',
                sources: ['native']
            },
            shuffleCards: {
                type: 'boolean',
                label: 'Shuffle cards?',
                defaultValue: 'false'
            },
            'textcolour': {
                type: 'colourpicker',
                label: 'Text Colour',
                defaultValue: '#000000',
                accordion: 'settings.advanced'
            },
            'textsize': {
                type: 'number',
                label: 'Text Size',
                showUnits: "Pt",
                defaultValue: 16,
                accordion: 'settings.advanced'
            },
            'cardBG': {
                type: 'colourpicker',
                label: 'Card Colour',
                defaultValue: '#b1e2ff',
                accordion: 'settings.advanced'
            },
            'cardborder': {
                type: 'colourpicker',
                label: 'Card Border',
                defaultValue: '#0000FF',
                accordion: 'settings.advanced'
            },
        },

        packageID: '3B876F512001BDF3427BEFC4A4785B04A982DFCCD48CCFD1',
        /**
         * Constructor. Runs when the widget is first loaded.
         *
         * @method init
         */
        init: function() {},

        /**
         * Event fired by the Site Controller.
         *
         * @event 'widget.live'
         */
        'widget.live': function(el, ev, data) {
            this.element.html(
                this.view('main.ejs')
            );
            var myArray = this.prefs.cardstext.value.split(';'),
                i=0,
                p=0;
            // Removes empty entries
            myArray = jQuery.grep(myArray, function(n){ return (n); });

            function Shuffle(o) {
                for(var j, x, i = o.length; i; j = parseInt(Math.random() * i), x = o[--i], o[i] = o[j], o[j] = x);
                return o;
            }
            if (this.prefs.shuffleCards.value===true) {
                Shuffle(myArray);
            }
            /* Show the edit mode if just added to a page, as otherwise the widget will be empty of cards */
            if (this.prefs.cardstext.value==="") {
                this.element.html(this.view('./widget.ejs'));
            } else {
                for (var c = 0; c < myArray.length; c++) {
                    this.element.find('.allcards').append(
                        this.view('card_1.ejs',{text:myArray[c]})
                    );
                } // end of iterating through array
            } // end of else
            this.element.find('.card').draggable({zIndex: 100});
            this.renderInEdit();
        },


        /**
         * Event fired by the Site Controller. Tells the widget that the site is in Edit Mode.
         *
         * @event 'widget.edit'
         */
        'widget.edit': function(el, ev, data) {
            this.element.html(
                this.view('./widget.ejs')
            );
            this.element.find('.instructions').show();
            this.renderInEdit();

        },

        'widget.save': function(el, ev, data) {
            this.renderInEdit();
        },
         renderInEdit : function() {
            var baseURL=Frog.Utilities.getBaseUrl();
            this.element.find('.card').css('color',this.prefs.textcolour.value);
            this.element.find('.card').css('font-size',this.prefs.textsize.value+'pt');
            this.element.find('.card').css('background',this.prefs.cardBG.value);
            this.element.find('.card').css('border-color',this.prefs.cardborder.value);
            if (this.prefs.bgimage.value) {
                this.element.find('.image').html(
                    '<img src="'+
                    baseURL+'/app/'+this.prefs.bgimage.value+
                    '">'
                );
            }
         },

        /**
         * Event fired by the Site Controller. Tells the widget that something has been changed during editing.
         *
         * @event 'widget.updated'
         */
        'widget.updated': function(el, ev, data) {

        }
    });
});