Com.Frog.Utils.require(
    '//package/widgets/258F69872001B9D91161EFF95A30CA00DC360EDC59FBEFB3/assets/styles/main.css',
    '//package/widgets/258F69872001B9D91161EFF95A30CA00DC360EDC59FBEFB3/assets/views/main.ejs',
    '//package/widgets/258F69872001B9D91161EFF95A30CA00DC360EDC59FBEFB3/assets/views/row.ejs',
    '//package/widgets/258F69872001B9D91161EFF95A30CA00DC360EDC59FBEFB3/assets/views/listItem.ejs',
    '//package/widgets/258F69872001B9D91161EFF95A30CA00DC360EDC59FBEFB3/assets/clipboard.js',
    '//package/widgets/258F69872001B9D91161EFF95A30CA00DC360EDC59FBEFB3/widget.ejs'
).then(function() {
    Com.Frog.Controllers.Widget.extend('Widget.AssignmentOpensReport', {
    }, {
        prefs: {   
            widgettitle: {
                type: 'text',
                label: 'Widget title',
                defaultValue: "Unopened Assignments"
            },
            reportlimit: {
                type: 'number',
                label: 'No. of assignments to check (larger numbers will take longer to run)',
                defaultValue: 100
            }
        },

        packageID: '258F69872001B9D91161EFF95A30CA00DC360EDC59FBEFB3',

        init: function() {},

        'widget.live': function(el, ev, data) {
            this.element.html(
                this.view(
                    'main.ejs',
                    {widgettitle: this.prefs.widgettitle.value}      
                )
            );      
            this.element.find('.form-group').hide(); // hide the subject dropdown - in case there is no data
            this.element.find('.copyTableButton').hide(); // hides the copy to clipboard button
            Frog.Model.api('assignmentreports.getColumns', {
                report_name: "monitor.assignments",
                filters: {status: "all"},
                order: [{direction: "desc", term: "issue_date"}]
            }).done(function(subjectResponse) {
                var subjects = subjectResponse.data[1].options,
                    dropdown = this.element.find('#subjectChoice');
                $.each(subjects, function(indexsubject,subject) {
                    dropdown.append('<option value="'+$.EJS.clean(subject.value)+'">'+$.EJS.clean(subject.text)+'</option>');
                });
                this.element.find('.form-group').show(); // show once loaded.
            }.bind(this));

            this.element.find('.assOpenData').hide();
            
            steal.import('frogui/modules/selectusers/selectusers!frog-component').then(function() {

                var groupName = this.element.find("div.group-select input.groupName"),
                    groupSelect = this.element.find("div.group-select");

                groupSelect.frogui_modules_selectusers({
                    show_label: false,
                    show_permission: false,
                    show_submit: true,
                    submit_label: 'List unopened assignments',
                    allow_convert: false,
                    search_users: false,
                    max_selections: 1,
                    profiles: ['student']
                });
                
            }.bind(this));
        },
        'selectusers.submitted': function() {
            var self = this,
                groupSelect = this.element.find("div.group-select"),
                startDat = self.element.find('#datePicker').val(),
                endDat = self.element.find('#datePickerEnd').val(),
                from = moment().unix()  - (7*24*60*60), // one week before today
                to = moment().unix(),
                today = "this week",
                AssignmentTotal = 0;
            
            self.element.find('h4').html('');

            self.element.find('.assOpenData').html(
                '<tr>'+
                '<th><b>First Name</b></th>'+
                '<th><b>Surname</b></th>'+
                '<th><b>Username</b></th>'+
                '<th><b>Assignments '+$.EJS.clean(self.element.find('#optradio:checked').val())+'<br>in this period</b></th>'+
                '<th><b>Assignments Unopened</b></th>'+
                '<th><b>No. Unopened</b></th>'+
                '<th><b>Unopened %</b></th>'+
                '<tr>'
            );
            if (startDat && endDat) {
                from = moment( startDat ).unix();
                to =  moment( endDat ).unix(); 
            }
            today = 'between: '+moment.unix(from).format('DD/MM/YYYY')+' & '+moment.unix(to).format('DD/MM/YYYY');
            groupSelect.trigger('selectusers.getSelected', function(data) {
                if (!data.groups.length) {
                    return;
                }
                var selectedGroup = data.groups[0].uuid,
                    classMembers = [];
                
                // Get all members of the group and add them to an array, using their UUID as the key            
                Frog.Model.api('groups.getMembers', {
                    uuid: selectedGroup,
                    ignore_profiles: 'true'
                }).done(function(studentResponse) {
                    var members = studentResponse.data,
                        allGroup = {};

                    members.sort(function(a, b){var a1= a.surname.toLowerCase(), b1= b.surname.toLowerCase();if(a1== b1) return 0; return a1> b1? 1: -1;});
                        
                    $.each(members, function(index,member) {
                        allGroup[member.uuid] = member;
                        allGroup[member.uuid]['count'] = 0;
                        allGroup[member.uuid]['unreadCount'] = 0;
                        allGroup[member.uuid]['unread'] = '';  
          
                        self.element.find('.assOpenData').append(
                            self.view('row.ejs', {
                                forename: member.forename,
                                surname: member.surname,
                                username: member.username,
                                uuid: member.uuid,
                                count: member.count,
                                unread: member.unread,
                                unreadCount: member.unreadCount
                            })
                        );
                    });
                    self.element.find('.assOpenData').show();
                    var adjustablefilter = {
                        status: 'all',
                        due_date: {
                            from: from, 
                            to: to 
                        }
                    }
                   if (self.element.find('#optradio:checked').val() == 'issued') {
                       adjustablefilter = {
                            status: 'all',
                            issue_date: {
                                from: from, 
                                to: to 
                            }
                        }
                   }
          
                    if (self.element.find('#subjectChoice').val() !== 'All') {
                            Object.assign(adjustablefilter, {subject_name: self.element.find('#subjectChoice').val()});
                    } 

                    Frog.Model.api('assignmentreports.getData', {
                        filters: adjustablefilter,
                        limit: self.prefs.reportlimit.value,
                        offset: 0,
                        order: [{directon: 'desc', term: 'issue_date'}],
                        report_name: 'monitor.assignments'
                    }).done(function(response) {
                        var assList = response.data,
                            count = assList.length;                 
                        // Now, list all entries in each assignment
                        $.each(assList, function(index1,assignment) {

                            Frog.Model.api('markbookmanager.getassignmentwithoutmarkbook', {
                                    assignment_uuid: assignment.assignment_uuid
                            }).done(function(AssResponse) {
                                
                                var allRows = AssResponse.data.row_data;  
                                $.each(allRows, function(index2,row) {
                                    $.each(row.assignments, function(index3,stu) {
                                        if (stu && allGroup.hasOwnProperty(stu.user_uuid)) {
                                            allGroup[stu.user_uuid].count += 1;
                                                    
                                            self.element.find('.count'+stu.user_uuid).text(allGroup[stu.user_uuid].count);                                                 
                                            if (stu.viewed == '0') {

                                                self.element.find('.list'+stu.user_uuid).append(
                                                    self.view( 'listItem.ejs', {
                                                        assName: assignment.assignment_name,
                                                        teacher: assignment.teacher_name,
                                                        subject: assignment.subject_name
                                                    })
                                                );
                                                allGroup[stu.user_uuid].unreadCount += 1;
                                            }
                                            var percent = Math.round(100*parseInt(allGroup[stu.user_uuid].unreadCount)/parseInt(allGroup[stu.user_uuid].count));
                                            self.element.find('.unread_count'+stu.user_uuid).text(allGroup[stu.user_uuid].unreadCount);     
                                            self.element.find('.unread_percent'+stu.user_uuid).text(percent+'%');    
                                        }
                                    });  // end of row
                                });  // end of all rows
                                
                                if (index1+1 === count) {
                                    // this will be executed at the end of the loop
                                    self.element.find('h4').html(self.element.find("#subjectChoice option:selected").text()+' '+self.prefs.widgettitle.value+' '+today);
                                    //console.log('finished');
                                    Frog.Controller.prototype.growl('Search completed','Assignment Opens Report','app-name',{time:'5000', icon: 'externalapps/icon/258F69872001B9D91161EFF95A30CA00DC360EDC59FBEFB3'});
                                    self.element.find('.copyTableButton').show();
                                }
                            }).fail(function(e) { // End of markbookmanager.getassignmentwithoutmarkbook         
                                console.log("failed to get markbook view");
                                Frog.Controller.prototype.growl('Assignment Information cannot be retrieved','Assignment Opens Report','app-name',{time:'5000', icon: 'externalapps/icon/258F69872001B9D91161EFF95A30CA00DC360EDC59FBEFB3'});
                            });
                        });  // end of assList each

                    }).fail(function(e) { // End of assignmentreports.getData                     
                        console.log("failed to get assignments");
                        Frog.Controller.prototype.growl('Assignment Information cannot be retrieved','Assignment Opens Report','app-name',{time:'5000', icon: 'externalapps/icon/258F69872001B9D91161EFF95A30CA00DC360EDC59FBEFB3'});
                    });
                }).fail(function(e) { // End of groups.getMembers                       
                    console.log("failed to get group members");
                    Frog.Controller.prototype.growl('Group Information cannot be retrieved','Assignment Opens Report','app-name',{time:'5000', icon: 'externalapps/icon/258F69872001B9D91161EFF95A30CA00DC360EDC59FBEFB3'});
                });  
            }); 

        },

        'widget.edit': function(el, ev, data) {
            this.element.html(
                this.view('./widget.ejs')
            );
        },
        '.copyTableButton click': function() {
            new Clipboard('.copyTableButton');
        },

        'widget.updated': function(el, ev, data) {}
    });
});

 
        
