Com.Frog.Utils.require(
    '//package/widgets/420C40562001B62E32AA9FAC601B9E007D4AAEFC2733ABBD/assets/styles/main.css',
    '//package/widgets/420C40562001B62E32AA9FAC601B9E007D4AAEFC2733ABBD/assets/views/main.ejs',
    '//package/widgets/420C40562001B62E32AA9FAC601B9E007D4AAEFC2733ABBD/assets/views/row.ejs',
    '//package/widgets/420C40562001B62E32AA9FAC601B9E007D4AAEFC2733ABBD/assets/clipboard.js',
    '//package/widgets/420C40562001B62E32AA9FAC601B9E007D4AAEFC2733ABBD/widget.ejs'
).then(function() {
    Com.Frog.Controllers.Widget.extend('Widget.AssignmentActivityHandins', {
    }, {
        prefs: {
            searchtype: {
                type: 'radio',
                label: "Select assignment status",
                vertical: true,
                options: {
                    'Open': 'open',
                    'Closed': 'closed'
                },
                defaultValue: "closed",
                publish: []
            },
            limit: {
                label: 'Search limit',
                type: 'number',
                defaultValue: 50
            },
            setfixedheight: {
                type: 'height',
                label: 'Height (px)',
                placeholder: 'placeholder text',
                options: {
                    on_text: 'auto',
                    off_text: 'manual'
                },
                defaultValue: 500
            }
        },
        selected_user_uuid: null,

        packageID: '420C40562001B62E32AA9FAC601B9E007D4AAEFC2733ABBD',

        init: function() {},

        'broadcast.selectedUser': function(el, ev, options) {
            if (options.model.attr('uuid') === this.selected_user_uuid) {
                return;
            }
            this.selected_user_uuid = options.model.attr('uuid');
            this.getAllHomeworks();
        },
        'widget.live': function(el, ev, data) {
            this.element.html(
                this.view('main.ejs')
            );
        },
        getAllHomeworks: function() {
            this.element.find('.assList').find('.stuRow').remove();
            FrogOS.fdp({
                url: 'assignment/getAssigned',
                path: '/api/fdp/1/',
                type: 'GET',
                data: {
                    status: this.prefs.searchtype.value,
                    assigned_user: this.selected_user_uuid,
                    limit: this.prefs.limit.value,
                    order: 'start desc'
                }
            }).done(function(response) {
                var assignments = response.response.assignments;

                $.each(assignments, function(index,hw) {

                    var dueDate = moment.unix(hw.assignment.end).format('ddd Do MMM YY'),
                        handinDate = moment.unix(hw.user_info.completed).format('ddd Do MMM YY'),
                        totalAct = parseInt(hw.activities.total),
                        stuAct = parseInt(hw.activities.complete),
                        bgClass = '',
                        overdue = '';
                    if (stuAct < totalAct) { // If the student has not submitted all activities, highlight in red
                         bgClass = 'redBox';
                    }    
                    if (hw.user_info.completed === null) { // if the student has not handed in work, remove date - which will appear as 1970
                        handinDate = '-';
                    }
                    if (hw.user_info.completed > hw.assignment.end) { // if the student handed in work late, highlight in red
                        overdue = 'redBox';
                    }
                    
                    this.element.find('.assList').append(
                         this.view('row.ejs', {
                                 assName: hw.assignment.name,
                                 subject: hw.assignment.subject.name,
                                 teacher: hw.creator.displayname,
                                 dueDate: dueDate,
                                 HandInDate: handinDate,
                                 totalAct: hw.activities.total,
                                 stuAct: hw.activities.complete,
                                 assLink: hw.assignment.link,
                                 uuid: hw.assignment.uuid,
                                 mark: hw.user_info.mark,
                                 comment: hw.user_info.comment,
                                 bgClass: bgClass,
                                 overdue: overdue
                         })
                    );
                }.bind(this))
                this.element.find('.copyTableButton').show();
            }.bind(this));
            if ( this.prefs.setfixedheight.value > 0) {
                this.element.find('.favouriteList').css('height', this.prefs.setfixedheight.value+'px');
                
            }
        },
    
        '.assDetails click': function (event,target) {
            FrogOS.openSite({
                site: event.data('link'),
                assignment_uuid: event.data('uuid')
            });
        },
        '.comment click': function (event,target) {
            if (event.hasClass("ellips")) {
                event.removeClass("ellips");
            } else {
                event.addClass("ellips");
            }
        },
        'widget.edit': function(el, ev, data) {
            this.element.html(
                this.view('./widget.ejs')
            );
        },
        '.copyTableButton click': function() {
            new Clipboard('.copyTableButton');
        },

        'widget.updated': function(el, ev, data) {}
    });
});
